/*
 * Decompiled with CFR 0.152.
 */
package io.github.detekt.test.utils;

import io.github.detekt.test.utils.Resources;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0001\u00a8\u0006\t"}, d2={"readResourceContent", "", "name", "resource", "Ljava/net/URI;", "resourceAsPath", "Ljava/nio/file/Path;", "resourceUrl", "Ljava/net/URL;", "detekt-test-utils"})
@SourceDebugExtension(value={"SMAP\nResources.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Resources.kt\nio/github/detekt/test/utils/ResourcesKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,24:1\n1#2:25\n*E\n"})
public final class ResourcesKt {
    @NotNull
    public static final URL resourceUrl(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String explicitName = StringsKt.startsWith$default((String)name, (String)"/", (boolean)false, (int)2, null) ? name : '/' + name;
        URL uRL = Resources.class.getResource(explicitName);
        if (uRL == null) {
            boolean bl = false;
            String string = "Make sure the resource '" + name + "' exists!";
            throw new IllegalArgumentException(string.toString());
        }
        return uRL;
    }

    @NotNull
    public static final URI resource(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        URI uRI = ResourcesKt.resourceUrl(name).toURI();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"toURI(...)");
        return uRI;
    }

    @NotNull
    public static final Path resourceAsPath(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Path path = Paths.get(ResourcesKt.resource(name));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    @NotNull
    public static final String readResourceContent(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Path path = ResourcesKt.resourceAsPath(name);
        StringBuilder stringBuilder = new StringBuilder();
        Path path2 = path;
        List<String> list = Files.readAllLines(path2, Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(list, (String)"readAllLines(...)");
        return stringBuilder.append(CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null)).append('\n').toString();
    }
}

