package transpropify;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Map.Entry;

public interface PropertySerializer {

    void serialize(Entry<String, String> entry, OutputStream outputStream) throws IOException;

    void serialize(Entry<String, String> entry, OutputStream outputStream, Charset charset) throws IOException;

    void serialize(KeyValue keyValue, OutputStream outputStream, Charset charset) throws IOException;

    Entry<String, String> deserialize(String keyValue);

    Map<String, String> load(File file) throws FileNotFoundException, IOException;
    
    Map<String, String> load(InputStream inputStream) throws IOException;
    
    Map<String, String> load(InputStreamReader inputStream) throws IOException;

}