package transpropify.converters;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;

import transpropify.PropertySerializer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Map;

public class ConverterMapToJson {

    private Gson gson = null;

    private boolean prettyPrinting = false;

    private final ConverterPropToJson varConverter;

    public ConverterMapToJson(PropertySerializer opusSerializer) {
        varConverter = new ConverterPropToJson(opusSerializer);
    }

    public void convertToStream(Map<String, String> opusContext, OutputStream outputStream) throws UnsupportedEncodingException, IOException {
        if (gson == null) {
            gson = JsonSerializer.newSerializer(prettyPrinting);
        }

        JsonElement finalJson = convert(opusContext);

        try (JsonWriter jsonWriter = gson.newJsonWriter(new OutputStreamWriter(outputStream, ConvertionConstants.DEFAULT_ENCODING))) {
            gson.toJson(finalJson, jsonWriter);
        }
    }

    public JsonElement convert(Map<String, String> opusContext) {
        opusContext.forEach((key, value) -> varConverter.putVar(key, value));

        JsonObject finalJson = varConverter.getFinalJson();

        return finalJson;
    }

    public ConverterMapToJson setPrettyPrinting(boolean activate) {
        this.prettyPrinting = activate;
        return this;
    }

    public ConverterMapToJson setPrettyPrinting() {
        this.prettyPrinting = true;
        return this;
    }
}
