package transpropify.converters;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

import transpropify.PropertySerializer;

import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;

public class ConverterPropToJson {

    private JsonObject root = null;

    private Map<String, JsonObject> allArrayObjects = null;

    private final PropertySerializer opusSerializer;

    public ConverterPropToJson(PropertySerializer opusSerializer) {
        this.opusSerializer = opusSerializer;
        reset();
    }

    public JsonElement putVar(String serializedVar) {
        Entry<String, String> entry = opusSerializer.deserialize(serializedVar);
        return putVar(entry);
    }

    public JsonElement putVar(Entry<String, String> entry) {
        return putVar(entry.getKey(), entry.getValue());
    }

    public JsonElement putVar(String varKey, String varValue) {
        JsonObject current = root;

        String fullkey = varKey;
        String[] subkeys = fullkey.split("\\.");
        if (subkeys.length < 1) {
            subkeys = new String[]{fullkey};
        }
        StringBuilder keystr = new StringBuilder();

        for (int ct = 0; ct < subkeys.length; ct++) {
            int nextct = ct + 1;
            String rawkey = subkeys[ct];
            KeyWithIndex itemKey = new KeyWithIndex(rawkey);

            if (ct > 0) {
                keystr.append(".");
            }
            keystr.append(rawkey);

            JsonElement element = current.get(itemKey.getKey());

            if (element == null) {
                if (itemKey.hasIndex()) {
                    JsonArray newArray = new JsonArray();
                    current.add(itemKey.getKey(), newArray);

                    if (!itemKey.isNullIndex()) {
                        JsonObject newElement = new JsonObject();
                        newElement.addProperty(ConvertionConstants.INDEX_NAME, itemKey.getIndex());
                        allArrayObjects.put(keystr.toString(), newElement);
                        newArray.add(newElement);
                        current = newElement;
                    } else {
                        //current = newArray;
                    }

                    if (itemKey.isNullIndex()) {
                        break;
                    }
                } else if (nextct < subkeys.length) {
                    JsonObject newElement = new JsonObject();
                    current.add(itemKey.getKey(), newElement);
                    current = newElement;
                    continue;
                } else if (nextct == subkeys.length) {
                    current.addProperty(itemKey.getKey(), varValue);
                    continue;
                }
            } else {
                if (itemKey.hasIndex() && !itemKey.isNullIndex()) {
                    JsonObject arrayElement = allArrayObjects.get(keystr.toString());
                    if (arrayElement == null) {
                        arrayElement = new JsonObject();
                        arrayElement.addProperty(ConvertionConstants.INDEX_NAME, itemKey.getIndex());

                        allArrayObjects.put(keystr.toString(), arrayElement);

                        JsonArray array = element.getAsJsonArray();
                        array.add(arrayElement);
                    }
                    current = arrayElement;
                } else {
                    if (!element.isJsonObject()) {
                        current.remove(itemKey.getKey());
                        current.addProperty(itemKey.getKey(), varValue);
                    } else {
                        current = element.getAsJsonObject();
                    }
                }
            }

            if (subkeys.length == nextct) {
                if (!itemKey.isNullIndex()) {
                    if (itemKey.hasIndex()) {
                        current.addProperty(ConvertionConstants.VALUE_NAME, varValue);
                    } else {
                        current.addProperty(itemKey.getKey(), varValue);
                    }
                }
            }
        }
        return root;
    }

    public JsonObject getPartialJson() {
        return root;
    }

    public JsonObject getFinalJson() {
        JsonObject resp = root;
        reset();

        return resp;
    }

    private void reset() {
        this.root = new JsonObject();
        this.allArrayObjects = new HashMap<>();
    }
}
