package transpropify.converters;

import org.apache.commons.lang3.StringUtils;

public class KeyWithIndex {

    private String key;
    private String index;
    private boolean nullIndex = false;

    public KeyWithIndex() {
        key = StringUtils.EMPTY;
        index = StringUtils.EMPTY;
    }

    public KeyWithIndex(String rawkey) {
        internalsplit(rawkey);
    }

    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getIndex() {
        return index;
    }

    public void setIndex(String index) {
        this.index = index;
        setNullIndex(StringUtils.isEmpty(this.index));
    }

    public boolean isNullIndex() {
        return nullIndex;
    }

    private void setNullIndex(boolean nullIndex) {
        this.nullIndex = nullIndex;
    }

    public static KeyWithIndex split(KeyWithIndex key, String rawkey) {
        if (!rawkey.endsWith("]")) {
            key.setKey(rawkey);
        } else {
            String[] splitindex = rawkey.split("\\[");
            key.setKey(splitindex[0]);
            if (splitindex.length > 1) {
                String index = splitindex[1].substring(0, splitindex[1].length() - 1);
                key.setIndex(index);
            }
        }

        return key;
    }

    public static KeyWithIndex split(String rawkey) {
        KeyWithIndex key = new KeyWithIndex();
        split(key, rawkey);
        return key;
    }

    public boolean hasIndex() {
        return this.isNullIndex() || !StringUtils.isEmpty(index);
    }

    private void internalsplit(String rawkey) {
        split(this, rawkey);
    }
}
