/*
 * Decompiled with CFR 0.152.
 */
package transpropify.converters;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Map;
import transpropify.PropertySerializer;
import transpropify.converters.ConverterPropToJson;
import transpropify.converters.JsonSerializer;

public class ConverterMapToJson {
    private Gson gson = null;
    private boolean prettyPrinting = false;
    private final ConverterPropToJson varConverter;

    public ConverterMapToJson(PropertySerializer opusSerializer) {
        this.varConverter = new ConverterPropToJson(opusSerializer);
    }

    public void convertToStream(Map<String, String> opusContext, OutputStream outputStream) throws UnsupportedEncodingException, IOException {
        if (this.gson == null) {
            this.gson = JsonSerializer.newSerializer(this.prettyPrinting);
        }
        JsonElement finalJson = this.convert(opusContext);
        try (JsonWriter jsonWriter = this.gson.newJsonWriter((Writer)new OutputStreamWriter(outputStream, "UTF-8"));){
            this.gson.toJson(finalJson, jsonWriter);
        }
    }

    public JsonElement convert(Map<String, String> opusContext) {
        opusContext.forEach((key, value) -> this.varConverter.putVar((String)key, (String)value));
        JsonObject finalJson = this.varConverter.getFinalJson();
        return finalJson;
    }

    public ConverterMapToJson setPrettyPrinting(boolean activate) {
        this.prettyPrinting = activate;
        return this;
    }

    public ConverterMapToJson setPrettyPrinting() {
        this.prettyPrinting = true;
        return this;
    }
}

