/*
 * Decompiled with CFR 0.152.
 */
package transpropify.converters;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

public class JsonSerializer {
    private static Gson gson = null;
    private static boolean prettyPrinting = false;

    public static Gson getDefaultSerializer() {
        if (gson != null) {
            return gson;
        }
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.disableHtmlEscaping();
        if (prettyPrinting) {
            gsonBuilder.setPrettyPrinting();
        }
        gson = gsonBuilder.create();
        return gson;
    }

    public static boolean getPrettyPrinting() {
        return prettyPrinting;
    }

    public static void setPrettyPrinting(boolean prettyPrinting) {
        if (JsonSerializer.prettyPrinting != prettyPrinting) {
            gson = null;
        }
        JsonSerializer.prettyPrinting = prettyPrinting;
    }

    public static Gson newSerializer(boolean prettyPrinting) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.disableHtmlEscaping();
        if (prettyPrinting) {
            gsonBuilder.setPrettyPrinting();
        }
        Gson gson = gsonBuilder.create();
        return gson;
    }
}

