/*
 * Decompiled with CFR 0.152.
 */
package transpropify.converters;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;

public class ConverterJsonToMap {
    private Map<String, String> mapresult;
    private JsonReader jsonReader;
    private boolean ignoreEmpty = true;

    public Map<String, String> convert(JsonElement obj) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            new Gson().toJson(obj, new JsonWriter((Writer)new OutputStreamWriter((OutputStream)outputStream, "UTF-8")));
        }
        catch (IOException ex) {
            throw new RuntimeException("Falha inesperada na codifica\u00e7\u00e3o do objeto json", ex);
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        try {
            return this.convert(inputStream);
        }
        catch (IOException ex) {
            throw new RuntimeException("Falha inesperada na codifica\u00e7\u00e3o do objeto json", ex);
        }
    }

    public Map<String, String> convert(String json) {
        ByteArrayInputStream stream = new ByteArrayInputStream(json.getBytes());
        try {
            return this.convert(stream);
        }
        catch (IOException ex) {
            throw new RuntimeException("Falha inesperada na codifica\u00e7\u00e3o do objeto json", ex);
        }
    }

    public Map<String, String> convert(InputStream stream) throws IOException {
        this.jsonReader = new JsonReader((Reader)new InputStreamReader(stream));
        this.mapresult = new TreeMap<String, String>();
        this.handleJsonObject();
        return this.mapresult;
    }

    private void handleJsonObject() throws IOException {
        this.handleJsonObject("", "");
    }

    private void handleJsonObject(String lastKey, String currentKey) throws IOException {
        this.handleJsonObject(lastKey, currentKey, "");
    }

    private void handleJsonObject(String parentKey, String nodeKey, String nodeIndex) throws IOException {
        JsonToken rootToken = this.jsonReader.peek();
        if (rootToken == JsonToken.BEGIN_ARRAY) {
            if (parentKey.isEmpty() && nodeKey.isEmpty()) {
                this.handleJsonArray("", "");
                return;
            }
            this.jsonReader.beginArray();
        } else if (rootToken == JsonToken.BEGIN_OBJECT) {
            this.jsonReader.beginObject();
        } else {
            throw new RuntimeException(String.format("Expected a json object or json array (parentKey:'%s', nodeKey:'%s', nodeIndex:'%s', token:'%s')", parentKey, nodeKey, nodeIndex, rootToken.name()));
        }
        StringBuilder parentKeyStr = new StringBuilder(parentKey);
        if (nodeKey.length() > 0) {
            if (parentKeyStr.length() > 0) {
                parentKeyStr.append(".");
            }
            parentKeyStr.append(nodeKey);
        }
        String newNodeKey = "";
        StringBuilder newParentKeyStr = null;
        block12: while (this.jsonReader.hasNext()) {
            JsonToken token = this.jsonReader.peek();
            switch (token) {
                case BEGIN_ARRAY: {
                    if (StringUtils.isEmpty((CharSequence)newNodeKey)) {
                        throw new RuntimeException(String.format("Falha separando array json. Elemento sem nome (parentKey:'%s', nodeKey:'%s', nodeIndex:'%s')", parentKey, nodeKey, nodeIndex));
                    }
                    newParentKeyStr = new StringBuilder(parentKeyStr);
                    if (StringUtils.isNotEmpty((CharSequence)nodeIndex)) {
                        newParentKeyStr.append("[").append(nodeIndex).append("]");
                    }
                    if (this.handleJsonArray(newParentKeyStr.toString(), newNodeKey) != 0) continue block12;
                    String newItemKey = newParentKeyStr.toString();
                    newItemKey = newItemKey + (StringUtils.isNotEmpty((CharSequence)newItemKey) ? "." : "");
                    newItemKey = newItemKey + newNodeKey + "[]";
                    this.mapresult.put(newItemKey, "");
                    continue block12;
                }
                case END_ARRAY: {
                    this.jsonReader.endArray();
                    continue block12;
                }
                case BEGIN_OBJECT: {
                    if (StringUtils.isEmpty((CharSequence)newNodeKey)) {
                        throw new RuntimeException(String.format("Falha separando json. Objeto json sem nome (parentKey:'%s', nodeKey:'%s', nodeIndex:'%s')", parentKey, nodeKey, nodeIndex));
                    }
                    newParentKeyStr = new StringBuilder(parentKeyStr);
                    if (StringUtils.isNotEmpty((CharSequence)nodeIndex)) {
                        newParentKeyStr.append("[").append(nodeIndex).append("]");
                    }
                    this.handleJsonObject(newParentKeyStr.toString(), newNodeKey);
                    continue block12;
                }
                case END_OBJECT: {
                    this.jsonReader.endObject();
                    continue block12;
                }
                case NAME: {
                    newNodeKey = this.jsonReader.nextName();
                    if (!newNodeKey.equals("_id_")) continue block12;
                    nodeIndex = this.jsonReader.nextString();
                    continue block12;
                }
            }
            StringBuilder newItemKeyStr = new StringBuilder();
            if (!newNodeKey.equals("_value_")) {
                if (parentKeyStr.length() > 0) {
                    newItemKeyStr.append((CharSequence)parentKeyStr);
                    if (StringUtils.isNotEmpty((CharSequence)nodeIndex)) {
                        newItemKeyStr.append("[");
                        newItemKeyStr.append(nodeIndex);
                        newItemKeyStr.append("]");
                    }
                    newItemKeyStr.append(".");
                    newItemKeyStr.append(newNodeKey);
                } else {
                    if (StringUtils.isNotEmpty((CharSequence)nodeIndex)) {
                        newItemKeyStr.append("[");
                        newItemKeyStr.append(nodeIndex);
                        newItemKeyStr.append("]");
                        newItemKeyStr.append(".");
                    }
                    newItemKeyStr.append(newNodeKey);
                }
            } else if (StringUtils.isNotEmpty((CharSequence)nodeIndex)) {
                if (newItemKeyStr.length() <= 0 && parentKeyStr.length() > 0) {
                    newItemKeyStr.append((CharSequence)parentKeyStr);
                }
                newItemKeyStr.append("[");
                newItemKeyStr.append(nodeIndex);
                newItemKeyStr.append("]");
            }
            String newItemKey = newItemKeyStr.toString();
            switch (token) {
                case STRING: 
                case NUMBER: {
                    String value = this.jsonReader.nextString();
                    if (this.ignoreEmpty && !StringUtils.isNotEmpty((CharSequence)value)) continue block12;
                    this.mapresult.put(newItemKey, value);
                    continue block12;
                }
                case BOOLEAN: {
                    boolean value = this.jsonReader.nextBoolean();
                    this.mapresult.put(newItemKey, value ? "S" : "N");
                    continue block12;
                }
                case NULL: {
                    this.jsonReader.skipValue();
                    this.mapresult.put(newItemKey, "");
                    continue block12;
                }
            }
            throw new RuntimeException(String.format("Falha separando json. Token n\u00e3o suportado (parentKey:'%s', nodeKey:'%s', nodeIndex:'%s', token:'%s')", parentKey, nodeKey, nodeIndex, token.name()));
        }
        if (rootToken == JsonToken.BEGIN_ARRAY) {
            this.jsonReader.endArray();
        } else if (rootToken == JsonToken.BEGIN_OBJECT) {
            this.jsonReader.endObject();
        }
    }

    private int handleJsonArray(String parentKey, String currentKey) throws IOException {
        JsonToken token;
        this.jsonReader.beginArray();
        StringBuilder strkey = new StringBuilder();
        if (parentKey.length() > 0) {
            strkey.append(parentKey);
            strkey.append(".");
        }
        if (currentKey.length() > 0) {
            strkey.append(currentKey);
        }
        String newNodeKey = "";
        int autoindex = 0;
        while ((token = this.jsonReader.peek()) != null && !token.equals((Object)JsonToken.END_ARRAY)) {
            block0 : switch (token) {
                case BEGIN_OBJECT: {
                    this.handleJsonObject(strkey.toString(), newNodeKey, String.valueOf(autoindex));
                    break;
                }
                case BEGIN_ARRAY: {
                    this.handleJsonArray(strkey.toString() + "[" + autoindex + "]", "");
                    break;
                }
                case END_OBJECT: {
                    this.jsonReader.endObject();
                    return autoindex;
                }
                case END_ARRAY: {
                    this.jsonReader.endArray();
                    return autoindex;
                }
                case STRING: 
                case NUMBER: 
                case BOOLEAN: 
                case NULL: {
                    StringBuilder newItemKeyStr = new StringBuilder();
                    if (strkey.length() > 0) {
                        newItemKeyStr.append((CharSequence)strkey);
                    }
                    newItemKeyStr.append("[");
                    newItemKeyStr.append(autoindex);
                    newItemKeyStr.append("]");
                    String newItemKey = newItemKeyStr.toString();
                    switch (token) {
                        case STRING: 
                        case NUMBER: {
                            String value = this.jsonReader.nextString();
                            if (this.ignoreEmpty && !StringUtils.isNotEmpty((CharSequence)value)) break block0;
                            this.mapresult.put(newItemKey, value);
                            break block0;
                        }
                        case BOOLEAN: {
                            boolean value = this.jsonReader.nextBoolean();
                            this.mapresult.put(newItemKey, value ? "S" : "N");
                            break block0;
                        }
                        case NULL: {
                            this.jsonReader.skipValue();
                            this.mapresult.put(newItemKey, "");
                            break block0;
                        }
                        default: {
                            throw new RuntimeException(String.format("Falha separando json. Token n\u00e3o suportado (strkey:'%s', autoindex:'%d', token:'%s')", strkey.toString(), autoindex, token.name()));
                        }
                    }
                }
                default: {
                    throw new RuntimeException(String.format("Falha separando array json. Token inesperado (lastKey:'%s', currentKey:'%s', strkey:'%s', token:%s, autoindex:%d)", parentKey, currentKey, strkey.toString(), token.toString(), autoindex));
                }
            }
            ++autoindex;
        }
        this.jsonReader.endArray();
        return autoindex;
    }

    public ConverterJsonToMap setKeepEmpties() {
        this.ignoreEmpty = false;
        return this;
    }
}

