/*
 * Decompiled with CFR 0.152.
 */
package transpropify.converters;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Map;
import transpropify.PropertySerializer;
import transpropify.converters.ConverterPropToJson;
import transpropify.converters.JsonSerializer;

public class ConverterMapToJson {
    private Gson gson = null;
    private boolean prettyPrinting = false;
    private final ConverterPropToJson varConverter;
    private boolean forceMixedIndexStyle = false;

    public ConverterMapToJson(PropertySerializer opusSerializer) {
        this.varConverter = new ConverterPropToJson(opusSerializer);
    }

    public ConverterMapToJson(PropertySerializer opusSerializer, boolean forceMixedIndexesStyle) {
        this.varConverter = new ConverterPropToJson(opusSerializer);
        this.forceMixedIndexStyle = forceMixedIndexesStyle;
    }

    public void convertToStream(Map<String, String> opusContext, OutputStream outputStream) throws UnsupportedEncodingException, IOException {
        if (this.gson == null) {
            this.gson = JsonSerializer.newSerializer(this.prettyPrinting);
        }
        JsonElement finalJson = this.convert(opusContext);
        try (JsonWriter jsonWriter = this.gson.newJsonWriter((Writer)new OutputStreamWriter(outputStream, "UTF-8"));){
            this.gson.toJson(finalJson, jsonWriter);
        }
    }

    public JsonElement convert(Map<String, String> opusContext) {
        return this.convert(opusContext, this.forceMixedIndexStyle);
    }

    public JsonElement convert(Map<String, String> opusContext, boolean forceMixedIndexesStyle) {
        boolean isTopLevelArray;
        opusContext.forEach((key, value) -> this.varConverter.putVar((String)key, (String)value));
        JsonObject finalJson = this.varConverter.getFinalJson();
        boolean bl = isTopLevelArray = !opusContext.isEmpty() && opusContext.keySet().stream().allMatch(key -> key.startsWith("["));
        if (isTopLevelArray) {
            JsonElement arrayElement = finalJson.get("");
            if (arrayElement != null && arrayElement.isJsonArray()) {
                boolean hasMixedIndexes;
                JsonArray jsonArray = arrayElement.getAsJsonArray();
                boolean bl2 = hasMixedIndexes = forceMixedIndexesStyle ? forceMixedIndexesStyle : this.checkTopLevelArrayHasMixedIndexes(opusContext);
                if (hasMixedIndexes) {
                    JsonArray resultArray = new JsonArray();
                    for (int i = 0; i < jsonArray.size(); ++i) {
                        JsonElement element = jsonArray.get(i);
                        if (element.isJsonObject()) {
                            JsonObject obj = element.getAsJsonObject();
                            JsonObject newObj = new JsonObject();
                            if (obj.has("_id_")) {
                                newObj.add("_id_", obj.get("_id_"));
                            }
                            if (obj.has("")) {
                                JsonElement emptyKeyElement = obj.get("");
                                if (emptyKeyElement != null && emptyKeyElement.isJsonArray()) {
                                    String parentIndex = obj.get("_id_").getAsString();
                                    boolean nestedArrayHasMixedIndexes = this.checkNestedArrayHasMixedIndexes(parentIndex, opusContext);
                                    JsonArray innerArray = emptyKeyElement.getAsJsonArray();
                                    JsonArray processedInnerArray = this.processArrayForIntegerKeys(innerArray, !nestedArrayHasMixedIndexes, forceMixedIndexesStyle, opusContext);
                                    newObj.add("_value_", (JsonElement)processedInnerArray);
                                } else {
                                    newObj.add("_value_", emptyKeyElement);
                                }
                            }
                            for (String key2 : obj.keySet()) {
                                if ("_id_".equals(key2) || "".equals(key2)) continue;
                                newObj.add(key2, obj.get(key2));
                            }
                            resultArray.add((JsonElement)newObj);
                            continue;
                        }
                        resultArray.add(element);
                    }
                    return resultArray;
                }
                JsonArray resultArray = new JsonArray();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JsonElement element = jsonArray.get(i);
                    if (element.isJsonObject()) {
                        JsonElement emptyKeyElement;
                        JsonObject obj = element.getAsJsonObject();
                        if (obj.size() == 2 && obj.has("_id_") && obj.has("") && (emptyKeyElement = obj.get("")) != null && emptyKeyElement.isJsonArray()) {
                            JsonArray innerArray = emptyKeyElement.getAsJsonArray();
                            String parentIndex = obj.get("_id_").getAsString();
                            boolean nestedArrayHasMixedIndexes = this.checkNestedArrayHasMixedIndexes(parentIndex, opusContext);
                            JsonArray processedInnerArray = this.processArrayForIntegerKeys(innerArray, !nestedArrayHasMixedIndexes, forceMixedIndexesStyle, opusContext);
                            resultArray.add((JsonElement)processedInnerArray);
                            continue;
                        }
                        if (obj.size() == 2 && obj.has("_id_") && obj.has("_value_")) {
                            JsonElement valueElement = obj.get("_value_");
                            if (valueElement == null) continue;
                            String valueStr = valueElement.getAsString();
                            try {
                                if (valueStr.matches("-?\\d+")) {
                                    resultArray.add((Number)Integer.parseInt(valueStr));
                                    continue;
                                }
                                if (valueStr.matches("-?\\d*\\.\\d+")) {
                                    resultArray.add((Number)Double.parseDouble(valueStr));
                                    continue;
                                }
                                resultArray.add(valueStr);
                            }
                            catch (NumberFormatException e) {
                                resultArray.add(valueStr);
                            }
                            continue;
                        }
                        JsonObject newObj = new JsonObject();
                        for (String key3 : obj.keySet()) {
                            if ("_id_".equals(key3)) continue;
                            JsonElement value2 = obj.get(key3);
                            value2 = this.processJsonForIntegerArrays(value2, opusContext, forceMixedIndexesStyle);
                            newObj.add(key3, value2);
                        }
                        resultArray.add((JsonElement)newObj);
                        continue;
                    }
                    resultArray.add(element);
                }
                return resultArray;
            }
        } else {
            return this.processJsonForIntegerArrays((JsonElement)finalJson, opusContext, forceMixedIndexesStyle);
        }
        return finalJson;
    }

    private JsonElement processJsonForIntegerArrays(JsonElement element, Map<String, String> opusContext, boolean forceMixedIndexStyle) {
        if (element.isJsonObject()) {
            JsonObject obj = element.getAsJsonObject();
            JsonObject newObj = new JsonObject();
            for (String key : obj.keySet()) {
                JsonElement value = obj.get(key);
                if (value.isJsonArray()) {
                    boolean allNumericIndices = forceMixedIndexStyle ? false : this.checkAllNumericIndices(key, opusContext);
                    newObj.add(key, (JsonElement)this.processArrayForIntegerKeys(value.getAsJsonArray(), allNumericIndices, forceMixedIndexStyle, opusContext));
                    continue;
                }
                newObj.add(key, this.processJsonForIntegerArrays(value, opusContext, forceMixedIndexStyle));
            }
            return newObj;
        }
        if (element.isJsonArray()) {
            boolean shouldRemoveIds = false;
            JsonArray array = element.getAsJsonArray();
            if (array.size() >= 3 && this.hasSequentialNumericIds(array)) {
                shouldRemoveIds = true;
            }
            return this.processArrayForIntegerKeys(array, shouldRemoveIds, forceMixedIndexStyle, opusContext);
        }
        return element;
    }

    private boolean checkAllNumericIndices(String arrayName, Map<String, String> opusContext) {
        boolean foundArrayKeys = false;
        boolean allNumericIndices = true;
        for (String key : opusContext.keySet()) {
            String pattern = arrayName + "[";
            int patternIndex = key.indexOf(pattern);
            while (patternIndex != -1) {
                boolean isValidArrayStart;
                boolean bl = isValidArrayStart = patternIndex == 0 || patternIndex > 0 && key.charAt(patternIndex - 1) == '.';
                if (isValidArrayStart) {
                    String index;
                    foundArrayKeys = true;
                    int startBracket = patternIndex + arrayName.length();
                    int endBracket = key.indexOf(93, startBracket + 1);
                    if (endBracket == -1 || (index = key.substring(startBracket + 1, endBracket)).matches("\\d+")) break;
                    allNumericIndices = false;
                    break;
                }
                patternIndex = key.indexOf(pattern, patternIndex + 1);
            }
            if (allNumericIndices) continue;
            break;
        }
        boolean isShortArrayName = arrayName.length() <= 1;
        return foundArrayKeys && allNumericIndices && isShortArrayName;
    }

    private JsonArray processArrayForIntegerKeys(JsonArray jsonArray, boolean shouldRemoveIds, boolean forceMixedIndexStyle, Map<String, String> opusContext) {
        boolean shouldRemoveIdsForThisArray;
        boolean allSequentialNumericIds = this.hasSequentialNumericIds(jsonArray);
        boolean bl = forceMixedIndexStyle ? false : (shouldRemoveIdsForThisArray = shouldRemoveIds || allSequentialNumericIds);
        if (shouldRemoveIdsForThisArray) {
            JsonArray resultArray = new JsonArray();
            for (int i = 0; i < jsonArray.size(); ++i) {
                JsonElement element = jsonArray.get(i);
                if (element.isJsonObject()) {
                    JsonObject obj = element.getAsJsonObject();
                    if (obj.size() == 2 && obj.has("_id_") && obj.has("_value_")) {
                        JsonElement valueElement = obj.get("_value_");
                        if (valueElement == null) continue;
                        String valueStr = valueElement.getAsString();
                        try {
                            if (valueStr.matches("-?\\d+")) {
                                resultArray.add((Number)Integer.parseInt(valueStr));
                                continue;
                            }
                            if (valueStr.matches("-?\\d*\\.\\d+")) {
                                resultArray.add((Number)Double.parseDouble(valueStr));
                                continue;
                            }
                            resultArray.add(valueStr);
                        }
                        catch (NumberFormatException e) {
                            resultArray.add(valueStr);
                        }
                        continue;
                    }
                    JsonObject newObj = new JsonObject();
                    for (String key : obj.keySet()) {
                        if ("_id_".equals(key)) continue;
                        JsonElement value = obj.get(key);
                        if (opusContext != null) {
                            value = this.processJsonForIntegerArrays(value, opusContext, !shouldRemoveIdsForThisArray);
                        }
                        newObj.add(key, value);
                    }
                    resultArray.add((JsonElement)newObj);
                    continue;
                }
                resultArray.add(element);
            }
            return resultArray;
        }
        JsonArray resultArray = new JsonArray();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JsonElement element = jsonArray.get(i);
            if (element.isJsonObject()) {
                JsonObject obj = element.getAsJsonObject();
                JsonObject newObj = new JsonObject();
                for (String key : obj.keySet()) {
                    if ("_id_".equals(key) && shouldRemoveIds) continue;
                    JsonElement value = obj.get(key);
                    if (opusContext != null) {
                        value = this.processJsonForIntegerArrays(value, opusContext, !shouldRemoveIdsForThisArray);
                    }
                    newObj.add(key, value);
                }
                resultArray.add((JsonElement)newObj);
                continue;
            }
            resultArray.add(element);
        }
        return resultArray;
    }

    private boolean hasSequentialNumericIds(JsonArray jsonArray) {
        if (jsonArray.size() == 0) {
            return false;
        }
        for (int i = 0; i < jsonArray.size(); ++i) {
            JsonElement element = jsonArray.get(i);
            if (element.isJsonObject()) {
                JsonObject obj = element.getAsJsonObject();
                JsonElement idElement = obj.get("_id_");
                if (idElement == null || !idElement.isJsonPrimitive()) {
                    return false;
                }
                String id = idElement.getAsString();
                if (id.equals(String.valueOf(i))) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private boolean checkTopLevelArrayHasMixedIndexes(Map<String, String> opusContext) {
        boolean hasNumericIndex = false;
        boolean hasStringIndex = false;
        for (String key : opusContext.keySet()) {
            int endBracket;
            if (!key.startsWith("[") || !key.contains("]") || (endBracket = key.indexOf(93)) <= 1) continue;
            String index = key.substring(1, endBracket);
            if (index.startsWith("\"") && index.endsWith("\"")) {
                index = index.substring(1, index.length() - 1);
                hasStringIndex = true;
                continue;
            }
            if (index.matches("\\d+")) {
                hasNumericIndex = true;
                continue;
            }
            hasStringIndex = true;
        }
        return hasNumericIndex && hasStringIndex;
    }

    private boolean checkNestedArrayHasMixedIndexes(String parentIndex, Map<String, String> opusContext) {
        boolean hasNumericIndex = false;
        boolean hasStringIndex = false;
        String parentPrefix = "[" + parentIndex + "].";
        for (String key : opusContext.keySet()) {
            int endBracket;
            String remaining;
            if (!key.startsWith(parentPrefix) || !(remaining = key.substring(parentPrefix.length())).startsWith("[") || !remaining.contains("]") || (endBracket = remaining.indexOf(93)) <= 1) continue;
            String index = remaining.substring(1, endBracket);
            if (index.startsWith("\"") && index.endsWith("\"")) {
                index = index.substring(1, index.length() - 1);
                hasStringIndex = true;
                continue;
            }
            if (index.matches("\\d+")) {
                hasNumericIndex = true;
                continue;
            }
            hasStringIndex = true;
        }
        return hasNumericIndex && hasStringIndex;
    }

    public ConverterMapToJson setPrettyPrinting(boolean activate) {
        this.prettyPrinting = activate;
        return this;
    }

    public ConverterMapToJson setPrettyPrinting() {
        this.prettyPrinting = true;
        return this;
    }
}

