/*
 * Decompiled with CFR 0.152.
 */
package transpropify.converters;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import transpropify.PropertySerializer;
import transpropify.converters.KeyWithIndex;

public class ConverterPropToJson {
    private JsonObject root = null;
    private Map<String, JsonObject> allArrayObjects = null;
    private final PropertySerializer opusSerializer;

    public ConverterPropToJson(PropertySerializer opusSerializer) {
        this.opusSerializer = opusSerializer;
        this.reset();
    }

    public JsonElement putVar(String serializedVar) {
        Map.Entry<String, String> entry = this.opusSerializer.deserialize(serializedVar);
        return this.putVar(entry);
    }

    public JsonElement putVar(Map.Entry<String, String> entry) {
        return this.putVar(entry.getKey(), entry.getValue());
    }

    public JsonElement putVar(String varKey, String varValue) {
        JsonObject current = this.root;
        String fullkey = varKey;
        String[] subkeys = fullkey.split("\\.");
        if (subkeys.length < 1) {
            subkeys = new String[]{fullkey};
        }
        StringBuilder keystr = new StringBuilder();
        for (int ct = 0; ct < subkeys.length; ++ct) {
            int nextct = ct + 1;
            String rawkey = subkeys[ct];
            KeyWithIndex itemKey = new KeyWithIndex(rawkey);
            if (ct > 0) {
                keystr.append(".");
            }
            keystr.append(rawkey);
            JsonElement element = current.get(itemKey.getKey());
            if (element == null) {
                if (itemKey.hasIndex()) {
                    JsonArray newArray = new JsonArray();
                    current.add(itemKey.getKey(), (JsonElement)newArray);
                    if (!itemKey.isNullIndex()) {
                        JsonObject newElement = new JsonObject();
                        newElement.addProperty("_id_", itemKey.getIndex());
                        this.allArrayObjects.put(keystr.toString(), newElement);
                        newArray.add((JsonElement)newElement);
                        current = newElement;
                    }
                    if (itemKey.isNullIndex()) {
                        break;
                    }
                } else {
                    if (nextct < subkeys.length) {
                        JsonObject newElement = new JsonObject();
                        current.add(itemKey.getKey(), (JsonElement)newElement);
                        current = newElement;
                        continue;
                    }
                    if (nextct == subkeys.length) {
                        current.addProperty(itemKey.getKey(), varValue);
                        continue;
                    }
                }
            } else if (itemKey.hasIndex() && !itemKey.isNullIndex()) {
                JsonObject arrayElement = this.allArrayObjects.get(keystr.toString());
                if (arrayElement == null) {
                    arrayElement = new JsonObject();
                    arrayElement.addProperty("_id_", itemKey.getIndex());
                    this.allArrayObjects.put(keystr.toString(), arrayElement);
                    JsonArray array = element.getAsJsonArray();
                    array.add((JsonElement)arrayElement);
                }
                current = arrayElement;
            } else if (!element.isJsonObject()) {
                current.remove(itemKey.getKey());
                current.addProperty(itemKey.getKey(), varValue);
            } else {
                current = element.getAsJsonObject();
            }
            if (subkeys.length != nextct || itemKey.isNullIndex()) continue;
            if (itemKey.hasIndex()) {
                current.addProperty("_value_", varValue);
                continue;
            }
            current.addProperty(itemKey.getKey(), varValue);
        }
        return this.root;
    }

    public JsonObject getPartialJson() {
        return this.root;
    }

    public JsonObject getFinalJson() {
        JsonObject resp = this.root;
        this.reset();
        return resp;
    }

    private void reset() {
        this.root = new JsonObject();
        this.allArrayObjects = new HashMap<String, JsonObject>();
    }
}

