/*
 * Decompiled with CFR 0.152.
 */
package org.silbertb.proto.domainconverter;

import java.io.IOException;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;
import org.silbertb.proto.domainconverter.SourceWriter;
import org.silbertb.proto.domainconverter.conversion_data.ConversionData;
import org.silbertb.proto.domainconverter.converter.ConversionDataCreator;
import org.silbertb.proto.domainconverter.converter.ConverterLogger;

@SupportedAnnotationTypes(value={"org.silbertb.proto.domainconverter.annotations.ProtoClass", "org.silbertb.proto.domainconverter.annotations.ProtoEnum", "org.silbertb.proto.domainconverter.annotations.ProtoGlobalMapper", "org.silbertb.proto.domainconverter.annotations.ProtoConfigure"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class ConverterGenerator
extends AbstractProcessor {
    private SourceWriter sourceWriter;
    private ConverterLogger logger;
    private ConversionDataCreator conversionDataCreator;
    private int numberOfCalls = 0;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.sourceWriter = new SourceWriter(processingEnv);
        this.logger = new ConverterLogger(processingEnv);
        this.conversionDataCreator = new ConversionDataCreator(processingEnv, this.logger);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (this.numberOfCalls > 0) {
            return true;
        }
        ++this.numberOfCalls;
        ConversionData conversionData = this.conversionDataCreator.createConversionData(roundEnv);
        if (conversionData.classesData().isEmpty() && conversionData.enumData().isEmpty()) {
            return true;
        }
        try {
            this.sourceWriter.writeSource(conversionData);
        }
        catch (IOException ex) {
            this.logger.error("Failed to generate proto domain conversion class. Exception: " + ex);
            throw new RuntimeException(ex);
        }
        return true;
    }
}

