/*
 * Decompiled with CFR 0.152.
 */
package org.silbertb.proto.domainconverter;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.tools.JavaFileObject;
import org.silbertb.proto.domainconverter.conversion_data.ConversionData;

public class SourceWriter {
    private final ProcessingEnvironment processingEnv;

    public SourceWriter(ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
    }

    public void writeSource(ConversionData conversionData) throws IOException {
        DefaultMustacheFactory mf = new DefaultMustacheFactory();
        Mustache m = mf.compile("converter.mustache");
        Filer filer = this.processingEnv.getFiler();
        JavaFileObject fileObject = filer.createSourceFile(conversionData.converterPackage() + "." + conversionData.converterClass(), new Element[0]);
        try (PrintWriter out = new PrintWriter(fileObject.openWriter());){
            m.execute((Writer)out, (Object)conversionData);
            out.flush();
        }
    }
}

