/*
 * Decompiled with CFR 0.152.
 */
package org.silbertb.proto.domainconverter.conversion_data;

import java.util.List;
import org.silbertb.proto.domainconverter.conversion_data.BuilderData;
import org.silbertb.proto.domainconverter.conversion_data.DataWithDefault;
import org.silbertb.proto.domainconverter.conversion_data.FieldData;
import org.silbertb.proto.domainconverter.conversion_data.OneofBaseClassData;
import org.silbertb.proto.domainconverter.util.StringUtils;

public final class ClassData
implements DataWithDefault {
    private final String domainFullName;
    private final String domainClass;
    private final String protoFullName;
    private final String protoClass;
    private final String mapperClass;
    private final String mapperFullName;
    private final OneofBaseClassData oneofBaseClassData;
    private final List<FieldData> fieldsData;
    private final List<FieldData> constructorParameters;
    private final BuilderData builderData;
    private final boolean isDefault;

    public ClassData(String domainFullName, String protoFullName, String mapperFullName, OneofBaseClassData oneofBaseClassData, List<FieldData> fieldsData, List<FieldData> constructorParameters, BuilderData builderData, boolean isDefault) {
        this.domainFullName = domainFullName;
        this.protoFullName = protoFullName;
        this.mapperFullName = mapperFullName;
        this.oneofBaseClassData = oneofBaseClassData;
        this.fieldsData = fieldsData;
        this.constructorParameters = constructorParameters;
        this.domainClass = StringUtils.getSimpleName(domainFullName);
        this.protoClass = StringUtils.getSimpleName(protoFullName);
        this.mapperClass = mapperFullName == null ? null : StringUtils.getSimpleName(mapperFullName);
        this.builderData = builderData;
        this.isDefault = isDefault;
    }

    public boolean useBuilder() {
        return this.builderData != null;
    }

    public boolean hasMapper() {
        return this.mapperClass != null;
    }

    public boolean hasSetters() {
        return this.fieldsData != null && !this.fieldsData.isEmpty() && (this.builderData == null || this.builderData.useConstructorParams()) && this.oneofBaseClassData == null;
    }

    public static ClassDataBuilder builder() {
        return new ClassDataBuilder();
    }

    @Override
    public String domainFullName() {
        return this.domainFullName;
    }

    public String domainClass() {
        return this.domainClass;
    }

    public String protoFullName() {
        return this.protoFullName;
    }

    public String protoClass() {
        return this.protoClass;
    }

    public String mapperClass() {
        return this.mapperClass;
    }

    public String mapperFullName() {
        return this.mapperFullName;
    }

    public OneofBaseClassData oneofBaseClassData() {
        return this.oneofBaseClassData;
    }

    public List<FieldData> fieldsData() {
        return this.fieldsData;
    }

    public List<FieldData> constructorParameters() {
        return this.constructorParameters;
    }

    public BuilderData builderData() {
        return this.builderData;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClassData)) {
            return false;
        }
        ClassData other = (ClassData)o;
        if (this.isDefault() != other.isDefault()) {
            return false;
        }
        String this$domainFullName = this.domainFullName();
        String other$domainFullName = other.domainFullName();
        if (this$domainFullName == null ? other$domainFullName != null : !this$domainFullName.equals(other$domainFullName)) {
            return false;
        }
        String this$domainClass = this.domainClass();
        String other$domainClass = other.domainClass();
        if (this$domainClass == null ? other$domainClass != null : !this$domainClass.equals(other$domainClass)) {
            return false;
        }
        String this$protoFullName = this.protoFullName();
        String other$protoFullName = other.protoFullName();
        if (this$protoFullName == null ? other$protoFullName != null : !this$protoFullName.equals(other$protoFullName)) {
            return false;
        }
        String this$protoClass = this.protoClass();
        String other$protoClass = other.protoClass();
        if (this$protoClass == null ? other$protoClass != null : !this$protoClass.equals(other$protoClass)) {
            return false;
        }
        String this$mapperClass = this.mapperClass();
        String other$mapperClass = other.mapperClass();
        if (this$mapperClass == null ? other$mapperClass != null : !this$mapperClass.equals(other$mapperClass)) {
            return false;
        }
        String this$mapperFullName = this.mapperFullName();
        String other$mapperFullName = other.mapperFullName();
        if (this$mapperFullName == null ? other$mapperFullName != null : !this$mapperFullName.equals(other$mapperFullName)) {
            return false;
        }
        OneofBaseClassData this$oneofBaseClassData = this.oneofBaseClassData();
        OneofBaseClassData other$oneofBaseClassData = other.oneofBaseClassData();
        if (this$oneofBaseClassData == null ? other$oneofBaseClassData != null : !((Object)this$oneofBaseClassData).equals(other$oneofBaseClassData)) {
            return false;
        }
        List<FieldData> this$fieldsData = this.fieldsData();
        List<FieldData> other$fieldsData = other.fieldsData();
        if (this$fieldsData == null ? other$fieldsData != null : !((Object)this$fieldsData).equals(other$fieldsData)) {
            return false;
        }
        List<FieldData> this$constructorParameters = this.constructorParameters();
        List<FieldData> other$constructorParameters = other.constructorParameters();
        if (this$constructorParameters == null ? other$constructorParameters != null : !((Object)this$constructorParameters).equals(other$constructorParameters)) {
            return false;
        }
        BuilderData this$builderData = this.builderData();
        BuilderData other$builderData = other.builderData();
        return !(this$builderData == null ? other$builderData != null : !this$builderData.equals(other$builderData));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDefault() ? 79 : 97);
        String $domainFullName = this.domainFullName();
        result = result * 59 + ($domainFullName == null ? 43 : $domainFullName.hashCode());
        String $domainClass = this.domainClass();
        result = result * 59 + ($domainClass == null ? 43 : $domainClass.hashCode());
        String $protoFullName = this.protoFullName();
        result = result * 59 + ($protoFullName == null ? 43 : $protoFullName.hashCode());
        String $protoClass = this.protoClass();
        result = result * 59 + ($protoClass == null ? 43 : $protoClass.hashCode());
        String $mapperClass = this.mapperClass();
        result = result * 59 + ($mapperClass == null ? 43 : $mapperClass.hashCode());
        String $mapperFullName = this.mapperFullName();
        result = result * 59 + ($mapperFullName == null ? 43 : $mapperFullName.hashCode());
        OneofBaseClassData $oneofBaseClassData = this.oneofBaseClassData();
        result = result * 59 + ($oneofBaseClassData == null ? 43 : ((Object)$oneofBaseClassData).hashCode());
        List<FieldData> $fieldsData = this.fieldsData();
        result = result * 59 + ($fieldsData == null ? 43 : ((Object)$fieldsData).hashCode());
        List<FieldData> $constructorParameters = this.constructorParameters();
        result = result * 59 + ($constructorParameters == null ? 43 : ((Object)$constructorParameters).hashCode());
        BuilderData $builderData = this.builderData();
        result = result * 59 + ($builderData == null ? 43 : $builderData.hashCode());
        return result;
    }

    public String toString() {
        return "ClassData(domainFullName=" + this.domainFullName() + ", domainClass=" + this.domainClass() + ", protoFullName=" + this.protoFullName() + ", protoClass=" + this.protoClass() + ", mapperClass=" + this.mapperClass() + ", mapperFullName=" + this.mapperFullName() + ", oneofBaseClassData=" + this.oneofBaseClassData() + ", fieldsData=" + this.fieldsData() + ", constructorParameters=" + this.constructorParameters() + ", builderData=" + this.builderData() + ", isDefault=" + this.isDefault() + ")";
    }

    public static class ClassDataBuilder {
        private String domainFullName;
        private String protoFullName;
        private String mapperFullName;
        private OneofBaseClassData oneofBaseClassData;
        private List<FieldData> fieldsData;
        private List<FieldData> constructorParameters;
        private BuilderData builderData;
        private boolean isDefault;

        ClassDataBuilder() {
        }

        public ClassDataBuilder domainFullName(String domainFullName) {
            this.domainFullName = domainFullName;
            return this;
        }

        public ClassDataBuilder protoFullName(String protoFullName) {
            this.protoFullName = protoFullName;
            return this;
        }

        public ClassDataBuilder mapperFullName(String mapperFullName) {
            this.mapperFullName = mapperFullName;
            return this;
        }

        public ClassDataBuilder oneofBaseClassData(OneofBaseClassData oneofBaseClassData) {
            this.oneofBaseClassData = oneofBaseClassData;
            return this;
        }

        public ClassDataBuilder fieldsData(List<FieldData> fieldsData) {
            this.fieldsData = fieldsData;
            return this;
        }

        public ClassDataBuilder constructorParameters(List<FieldData> constructorParameters) {
            this.constructorParameters = constructorParameters;
            return this;
        }

        public ClassDataBuilder builderData(BuilderData builderData) {
            this.builderData = builderData;
            return this;
        }

        public ClassDataBuilder isDefault(boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        public ClassData build() {
            return new ClassData(this.domainFullName, this.protoFullName, this.mapperFullName, this.oneofBaseClassData, this.fieldsData, this.constructorParameters, this.builderData, this.isDefault);
        }

        public String toString() {
            return "ClassData.ClassDataBuilder(domainFullName=" + this.domainFullName + ", protoFullName=" + this.protoFullName + ", mapperFullName=" + this.mapperFullName + ", oneofBaseClassData=" + this.oneofBaseClassData + ", fieldsData=" + this.fieldsData + ", constructorParameters=" + this.constructorParameters + ", builderData=" + this.builderData + ", isDefault=" + this.isDefault + ")";
        }
    }
}

