/*
 * Decompiled with CFR 0.152.
 */
package org.silbertb.proto.domainconverter.conversion_data;

import org.silbertb.proto.domainconverter.conversion_data.FieldType;
import org.silbertb.proto.domainconverter.custom.ProtoType;
import org.silbertb.proto.domainconverter.util.StringUtils;

public class ConcreteFieldData {
    private final FieldType fieldType;
    private final String domainTypeFullName;
    private final String domainItemTypeFullName;
    private final String protoFieldPascalCase;
    private final String domainFieldMethodSuffix;
    private final String dataStructureConcreteType;
    private final String domainFieldName;
    private final String converterName;
    private final String converterFullName;
    private final ProtoType protoTypeForConverter;
    private final String generatedConverter;
    private final String explicitProtoFieldName;

    public ConcreteFieldData(FieldType fieldType, String domainItemTypeFullName, String domainFieldName, String domainTypeFullName, String explicitProtoFieldName, String dataStructureConcreteType, String converterFullName, ProtoType protoTypeForConverter, String generatedConverter) {
        this.fieldType = fieldType;
        this.domainItemTypeFullName = domainItemTypeFullName;
        this.explicitProtoFieldName = explicitProtoFieldName;
        this.protoFieldPascalCase = ConcreteFieldData.protoFieldPascalCase(domainFieldName, explicitProtoFieldName);
        this.domainFieldMethodSuffix = StringUtils.capitalize(domainFieldName);
        this.dataStructureConcreteType = dataStructureConcreteType;
        this.converterFullName = converterFullName;
        this.converterName = converterFullName == null ? null : StringUtils.getSimpleName(converterFullName);
        this.protoTypeForConverter = protoTypeForConverter;
        this.domainFieldName = domainFieldName;
        this.domainTypeFullName = domainTypeFullName;
        this.generatedConverter = generatedConverter;
    }

    private static String protoFieldPascalCase(String domainFieldName, String customProtoFieldName) {
        return customProtoFieldName.equals("") ? StringUtils.capitalize(domainFieldName) : StringUtils.snakeCaseToPascalCase(customProtoFieldName);
    }

    private String generatedConverterPrefix() {
        return this.generatedConverter == null ? "" : this.generatedConverter + ".";
    }

    public boolean hasConverter() {
        return this.converterName != null;
    }

    public String protoBuilderSetCommand() {
        switch (this.protoTypeForConverter) {
            case MAP: {
                return "putAll" + this.protoFieldPascalCase;
            }
            case LIST: {
                return "addAll" + this.protoFieldPascalCase;
            }
            case OTHER: 
            case MESSAGE: {
                return "set" + this.protoFieldPascalCase;
            }
        }
        throw new RuntimeException("Unhandled proto type: " + this.fieldType);
    }

    private String domainGetterMethodPrefix() {
        if (this.fieldType.equals((Object)FieldType.BOOLEAN)) {
            return "is";
        }
        return "get";
    }

    public String domainGetterMethod() {
        return this.domainGetterMethodPrefix() + this.domainFieldMethodSuffix;
    }

    private String protoGetterSuffix() {
        switch (this.protoTypeForConverter) {
            case LIST: {
                return "List";
            }
            case MAP: {
                return "Map";
            }
            case OTHER: 
            case MESSAGE: {
                return "";
            }
        }
        throw new RuntimeException("Unhandled proto type: " + this.protoTypeForConverter);
    }

    public String protoGetterMethod() {
        return "get" + this.protoFieldPascalCase + this.protoGetterSuffix();
    }

    public boolean isNullableDomainType() {
        switch (this.fieldType) {
            case MESSAGE: 
            case ENUM: 
            case PRIMITIVE_LIST: 
            case MESSAGE_LIST: 
            case PRIMITIVE_MAP: 
            case MAP_TO_MESSAGE: 
            case STRING: 
            case BYTES: {
                return true;
            }
            case OTHER: 
            case BOOLEAN: {
                return false;
            }
        }
        throw new RuntimeException("Unhandled field type: " + this.fieldType);
    }

    public String addToBuilderCommand() {
        switch (this.fieldType) {
            case BOOLEAN: {
                return "builder.set" + this.protoFieldPascalCase + "(domain.is" + this.domainFieldMethodSuffix + "())";
            }
            case MESSAGE: 
            case ENUM: {
                return "builder.set" + this.protoFieldPascalCase + "(" + this.generatedConverterPrefix() + "toProto(domain.get" + this.domainFieldMethodSuffix + "()))";
            }
            case PRIMITIVE_LIST: {
                return "builder.addAll" + this.protoFieldPascalCase + "(domain.get" + this.domainFieldMethodSuffix + "())";
            }
            case MESSAGE_LIST: {
                return "domain.get" + this.domainFieldMethodSuffix + "().forEach(item -> builder.add" + this.protoFieldPascalCase + "(" + this.generatedConverterPrefix() + "toProto(item)))";
            }
            case PRIMITIVE_MAP: {
                return "builder.putAll" + this.protoFieldPascalCase + "(domain.get" + this.domainFieldMethodSuffix + "())";
            }
            case MAP_TO_MESSAGE: {
                return "domain.get" + this.domainFieldMethodSuffix + "().forEach((key, value) -> builder.put" + this.protoFieldPascalCase + "(key, " + this.generatedConverterPrefix() + "toProto(value)))";
            }
            case BYTES: {
                return "builder.set" + this.protoFieldPascalCase + "(ByteString.copyFrom(domain.get" + this.domainFieldMethodSuffix + "()))";
            }
            case STRING: 
            case OTHER: {
                return "builder.set" + this.protoFieldPascalCase + "(domain.get" + this.domainFieldMethodSuffix + "())";
            }
        }
        throw new RuntimeException("Unhandled field type: " + this.fieldType);
    }

    public boolean isNullableProtoType() {
        return this.fieldType == FieldType.MESSAGE || this.protoTypeForConverter == ProtoType.MESSAGE;
    }

    public String convertProtoValue() {
        switch (this.fieldType) {
            case STRING: 
            case OTHER: 
            case BOOLEAN: {
                return "proto.get" + this.protoFieldPascalCase + "()";
            }
            case PRIMITIVE_MAP: {
                return "new " + this.dataStructureConcreteType + "<>(proto.get" + this.protoFieldPascalCase + "())";
            }
            case MESSAGE: 
            case ENUM: {
                return this.generatedConverterPrefix() + "toDomain(proto.get" + this.protoFieldPascalCase + "(), (" + this.domainTypeFullName + ") null)";
            }
            case PRIMITIVE_LIST: {
                return "new " + this.dataStructureConcreteType + "<>(proto.get" + this.protoFieldPascalCase + "List())";
            }
            case MESSAGE_LIST: {
                return "proto.get" + this.protoFieldPascalCase + "List().stream().map(item -> " + this.generatedConverterPrefix() + "toDomain(item, (" + this.domainItemTypeFullName + ") null)).collect(Collectors.toCollection(" + this.dataStructureConcreteType + "::new))";
            }
            case MAP_TO_MESSAGE: {
                return "proto.get" + this.protoFieldPascalCase + "Map().entrySet().stream().collect(Collectors.toMap(e -> e.getKey(), e -> " + this.generatedConverterPrefix() + "toDomain(e.getValue(), (" + this.domainItemTypeFullName + ") null), (v1, v2) -> v1, " + this.dataStructureConcreteType + "::new))";
            }
            case BYTES: {
                return "proto.get" + this.protoFieldPascalCase + "().toByteArray()";
            }
        }
        throw new RuntimeException("Unhandled field type: " + this.fieldType);
    }

    public boolean isMessage() {
        return this.fieldType.equals((Object)FieldType.MESSAGE);
    }

    public static ConcreteFieldDataBuilder builder() {
        return new ConcreteFieldDataBuilder();
    }

    public ConcreteFieldDataBuilder toBuilder() {
        return new ConcreteFieldDataBuilder().fieldType(this.fieldType).domainItemTypeFullName(this.domainItemTypeFullName).domainFieldName(this.domainFieldName).domainTypeFullName(this.domainTypeFullName).explicitProtoFieldName(this.explicitProtoFieldName).dataStructureConcreteType(this.dataStructureConcreteType).converterFullName(this.converterFullName).protoTypeForConverter(this.protoTypeForConverter).generatedConverter(this.generatedConverter);
    }

    public FieldType fieldType() {
        return this.fieldType;
    }

    public String domainTypeFullName() {
        return this.domainTypeFullName;
    }

    public String domainItemTypeFullName() {
        return this.domainItemTypeFullName;
    }

    public String protoFieldPascalCase() {
        return this.protoFieldPascalCase;
    }

    public String domainFieldMethodSuffix() {
        return this.domainFieldMethodSuffix;
    }

    public String dataStructureConcreteType() {
        return this.dataStructureConcreteType;
    }

    public String domainFieldName() {
        return this.domainFieldName;
    }

    public String converterName() {
        return this.converterName;
    }

    public String converterFullName() {
        return this.converterFullName;
    }

    public ProtoType protoTypeForConverter() {
        return this.protoTypeForConverter;
    }

    public String generatedConverter() {
        return this.generatedConverter;
    }

    public String explicitProtoFieldName() {
        return this.explicitProtoFieldName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConcreteFieldData)) {
            return false;
        }
        ConcreteFieldData other = (ConcreteFieldData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        FieldType this$fieldType = this.fieldType();
        FieldType other$fieldType = other.fieldType();
        if (this$fieldType == null ? other$fieldType != null : !((Object)((Object)this$fieldType)).equals((Object)other$fieldType)) {
            return false;
        }
        String this$domainTypeFullName = this.domainTypeFullName();
        String other$domainTypeFullName = other.domainTypeFullName();
        if (this$domainTypeFullName == null ? other$domainTypeFullName != null : !this$domainTypeFullName.equals(other$domainTypeFullName)) {
            return false;
        }
        String this$domainItemTypeFullName = this.domainItemTypeFullName();
        String other$domainItemTypeFullName = other.domainItemTypeFullName();
        if (this$domainItemTypeFullName == null ? other$domainItemTypeFullName != null : !this$domainItemTypeFullName.equals(other$domainItemTypeFullName)) {
            return false;
        }
        String this$protoFieldPascalCase = this.protoFieldPascalCase();
        String other$protoFieldPascalCase = other.protoFieldPascalCase();
        if (this$protoFieldPascalCase == null ? other$protoFieldPascalCase != null : !this$protoFieldPascalCase.equals(other$protoFieldPascalCase)) {
            return false;
        }
        String this$domainFieldMethodSuffix = this.domainFieldMethodSuffix();
        String other$domainFieldMethodSuffix = other.domainFieldMethodSuffix();
        if (this$domainFieldMethodSuffix == null ? other$domainFieldMethodSuffix != null : !this$domainFieldMethodSuffix.equals(other$domainFieldMethodSuffix)) {
            return false;
        }
        String this$dataStructureConcreteType = this.dataStructureConcreteType();
        String other$dataStructureConcreteType = other.dataStructureConcreteType();
        if (this$dataStructureConcreteType == null ? other$dataStructureConcreteType != null : !this$dataStructureConcreteType.equals(other$dataStructureConcreteType)) {
            return false;
        }
        String this$domainFieldName = this.domainFieldName();
        String other$domainFieldName = other.domainFieldName();
        if (this$domainFieldName == null ? other$domainFieldName != null : !this$domainFieldName.equals(other$domainFieldName)) {
            return false;
        }
        String this$converterName = this.converterName();
        String other$converterName = other.converterName();
        if (this$converterName == null ? other$converterName != null : !this$converterName.equals(other$converterName)) {
            return false;
        }
        String this$converterFullName = this.converterFullName();
        String other$converterFullName = other.converterFullName();
        if (this$converterFullName == null ? other$converterFullName != null : !this$converterFullName.equals(other$converterFullName)) {
            return false;
        }
        ProtoType this$protoTypeForConverter = this.protoTypeForConverter();
        ProtoType other$protoTypeForConverter = other.protoTypeForConverter();
        if (this$protoTypeForConverter == null ? other$protoTypeForConverter != null : !((Object)((Object)this$protoTypeForConverter)).equals((Object)other$protoTypeForConverter)) {
            return false;
        }
        String this$generatedConverter = this.generatedConverter();
        String other$generatedConverter = other.generatedConverter();
        if (this$generatedConverter == null ? other$generatedConverter != null : !this$generatedConverter.equals(other$generatedConverter)) {
            return false;
        }
        String this$explicitProtoFieldName = this.explicitProtoFieldName();
        String other$explicitProtoFieldName = other.explicitProtoFieldName();
        return !(this$explicitProtoFieldName == null ? other$explicitProtoFieldName != null : !this$explicitProtoFieldName.equals(other$explicitProtoFieldName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConcreteFieldData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FieldType $fieldType = this.fieldType();
        result = result * 59 + ($fieldType == null ? 43 : ((Object)((Object)$fieldType)).hashCode());
        String $domainTypeFullName = this.domainTypeFullName();
        result = result * 59 + ($domainTypeFullName == null ? 43 : $domainTypeFullName.hashCode());
        String $domainItemTypeFullName = this.domainItemTypeFullName();
        result = result * 59 + ($domainItemTypeFullName == null ? 43 : $domainItemTypeFullName.hashCode());
        String $protoFieldPascalCase = this.protoFieldPascalCase();
        result = result * 59 + ($protoFieldPascalCase == null ? 43 : $protoFieldPascalCase.hashCode());
        String $domainFieldMethodSuffix = this.domainFieldMethodSuffix();
        result = result * 59 + ($domainFieldMethodSuffix == null ? 43 : $domainFieldMethodSuffix.hashCode());
        String $dataStructureConcreteType = this.dataStructureConcreteType();
        result = result * 59 + ($dataStructureConcreteType == null ? 43 : $dataStructureConcreteType.hashCode());
        String $domainFieldName = this.domainFieldName();
        result = result * 59 + ($domainFieldName == null ? 43 : $domainFieldName.hashCode());
        String $converterName = this.converterName();
        result = result * 59 + ($converterName == null ? 43 : $converterName.hashCode());
        String $converterFullName = this.converterFullName();
        result = result * 59 + ($converterFullName == null ? 43 : $converterFullName.hashCode());
        ProtoType $protoTypeForConverter = this.protoTypeForConverter();
        result = result * 59 + ($protoTypeForConverter == null ? 43 : ((Object)((Object)$protoTypeForConverter)).hashCode());
        String $generatedConverter = this.generatedConverter();
        result = result * 59 + ($generatedConverter == null ? 43 : $generatedConverter.hashCode());
        String $explicitProtoFieldName = this.explicitProtoFieldName();
        result = result * 59 + ($explicitProtoFieldName == null ? 43 : $explicitProtoFieldName.hashCode());
        return result;
    }

    public String toString() {
        return "ConcreteFieldData(fieldType=" + this.fieldType() + ", domainTypeFullName=" + this.domainTypeFullName() + ", domainItemTypeFullName=" + this.domainItemTypeFullName() + ", protoFieldPascalCase=" + this.protoFieldPascalCase() + ", domainFieldMethodSuffix=" + this.domainFieldMethodSuffix() + ", dataStructureConcreteType=" + this.dataStructureConcreteType() + ", domainFieldName=" + this.domainFieldName() + ", converterName=" + this.converterName() + ", converterFullName=" + this.converterFullName() + ", protoTypeForConverter=" + this.protoTypeForConverter() + ", generatedConverter=" + this.generatedConverter() + ", explicitProtoFieldName=" + this.explicitProtoFieldName() + ")";
    }

    public static class ConcreteFieldDataBuilder {
        private FieldType fieldType;
        private String domainItemTypeFullName;
        private String domainFieldName;
        private String domainTypeFullName;
        private String explicitProtoFieldName;
        private String dataStructureConcreteType;
        private String converterFullName;
        private ProtoType protoTypeForConverter;
        private String generatedConverter;

        ConcreteFieldDataBuilder() {
        }

        public ConcreteFieldDataBuilder fieldType(FieldType fieldType) {
            this.fieldType = fieldType;
            return this;
        }

        public ConcreteFieldDataBuilder domainItemTypeFullName(String domainItemTypeFullName) {
            this.domainItemTypeFullName = domainItemTypeFullName;
            return this;
        }

        public ConcreteFieldDataBuilder domainFieldName(String domainFieldName) {
            this.domainFieldName = domainFieldName;
            return this;
        }

        public ConcreteFieldDataBuilder domainTypeFullName(String domainTypeFullName) {
            this.domainTypeFullName = domainTypeFullName;
            return this;
        }

        public ConcreteFieldDataBuilder explicitProtoFieldName(String explicitProtoFieldName) {
            this.explicitProtoFieldName = explicitProtoFieldName;
            return this;
        }

        public ConcreteFieldDataBuilder dataStructureConcreteType(String dataStructureConcreteType) {
            this.dataStructureConcreteType = dataStructureConcreteType;
            return this;
        }

        public ConcreteFieldDataBuilder converterFullName(String converterFullName) {
            this.converterFullName = converterFullName;
            return this;
        }

        public ConcreteFieldDataBuilder protoTypeForConverter(ProtoType protoTypeForConverter) {
            this.protoTypeForConverter = protoTypeForConverter;
            return this;
        }

        public ConcreteFieldDataBuilder generatedConverter(String generatedConverter) {
            this.generatedConverter = generatedConverter;
            return this;
        }

        public ConcreteFieldData build() {
            return new ConcreteFieldData(this.fieldType, this.domainItemTypeFullName, this.domainFieldName, this.domainTypeFullName, this.explicitProtoFieldName, this.dataStructureConcreteType, this.converterFullName, this.protoTypeForConverter, this.generatedConverter);
        }

        public String toString() {
            return "ConcreteFieldData.ConcreteFieldDataBuilder(fieldType=" + this.fieldType + ", domainItemTypeFullName=" + this.domainItemTypeFullName + ", domainFieldName=" + this.domainFieldName + ", domainTypeFullName=" + this.domainTypeFullName + ", explicitProtoFieldName=" + this.explicitProtoFieldName + ", dataStructureConcreteType=" + this.dataStructureConcreteType + ", converterFullName=" + this.converterFullName + ", protoTypeForConverter=" + this.protoTypeForConverter + ", generatedConverter=" + this.generatedConverter + ")";
        }
    }
}

