/*
 * Decompiled with CFR 0.152.
 */
package org.silbertb.proto.domainconverter.conversion_data;

import java.util.Collection;
import java.util.List;
import org.silbertb.proto.domainconverter.conversion_data.ClassData;
import org.silbertb.proto.domainconverter.conversion_data.ConfigurationData;
import org.silbertb.proto.domainconverter.conversion_data.EnumData;
import org.silbertb.proto.domainconverter.util.StringUtils;

public class ConversionData {
    private final ConfigurationData configurationData;
    private final String generator;
    private final String converterPackage;
    private final String converterClass;
    private final List<ClassData> classesData;
    private final Collection<ClassData> defaultClassesData;
    private final Collection<EnumData> defaultEnumsData;
    private final Collection<EnumData> enumData;

    private ConversionData(ConfigurationData configurationData, String generator, String converterFullName, List<ClassData> classesData, Collection<ClassData> defaultClassesData, Collection<EnumData> enumData, Collection<EnumData> defaultEnumsData) {
        this.configurationData = configurationData;
        this.generator = generator;
        this.converterPackage = StringUtils.getPackage(converterFullName);
        this.converterClass = StringUtils.getSimpleName(converterFullName);
        this.classesData = classesData;
        this.defaultClassesData = defaultClassesData;
        this.enumData = enumData;
        this.defaultEnumsData = defaultEnumsData;
    }

    public static ConversionDataBuilder builder() {
        return new ConversionDataBuilder();
    }

    public ConfigurationData configurationData() {
        return this.configurationData;
    }

    public String generator() {
        return this.generator;
    }

    public String converterPackage() {
        return this.converterPackage;
    }

    public String converterClass() {
        return this.converterClass;
    }

    public List<ClassData> classesData() {
        return this.classesData;
    }

    public Collection<ClassData> defaultClassesData() {
        return this.defaultClassesData;
    }

    public Collection<EnumData> defaultEnumsData() {
        return this.defaultEnumsData;
    }

    public Collection<EnumData> enumData() {
        return this.enumData;
    }

    public static class ConversionDataBuilder {
        private ConfigurationData configurationData;
        private String generator;
        private String converterFullName;
        private List<ClassData> classesData;
        private Collection<ClassData> defaultClassesData;
        private Collection<EnumData> enumData;
        private Collection<EnumData> defaultEnumsData;

        ConversionDataBuilder() {
        }

        public ConversionDataBuilder configurationData(ConfigurationData configurationData) {
            this.configurationData = configurationData;
            return this;
        }

        public ConversionDataBuilder generator(String generator) {
            this.generator = generator;
            return this;
        }

        public ConversionDataBuilder converterFullName(String converterFullName) {
            this.converterFullName = converterFullName;
            return this;
        }

        public ConversionDataBuilder classesData(List<ClassData> classesData) {
            this.classesData = classesData;
            return this;
        }

        public ConversionDataBuilder defaultClassesData(Collection<ClassData> defaultClassesData) {
            this.defaultClassesData = defaultClassesData;
            return this;
        }

        public ConversionDataBuilder enumData(Collection<EnumData> enumData) {
            this.enumData = enumData;
            return this;
        }

        public ConversionDataBuilder defaultEnumsData(Collection<EnumData> defaultEnumsData) {
            this.defaultEnumsData = defaultEnumsData;
            return this;
        }

        public ConversionData build() {
            return new ConversionData(this.configurationData, this.generator, this.converterFullName, this.classesData, this.defaultClassesData, this.enumData, this.defaultEnumsData);
        }

        public String toString() {
            return "ConversionData.ConversionDataBuilder(configurationData=" + this.configurationData + ", generator=" + this.generator + ", converterFullName=" + this.converterFullName + ", classesData=" + this.classesData + ", defaultClassesData=" + this.defaultClassesData + ", enumData=" + this.enumData + ", defaultEnumsData=" + this.defaultEnumsData + ")";
        }
    }
}

