/*
 * Decompiled with CFR 0.152.
 */
package org.silbertb.proto.domainconverter.conversion_data;

import java.util.Collection;
import org.silbertb.proto.domainconverter.conversion_data.DataWithDefault;
import org.silbertb.proto.domainconverter.conversion_data.EnumValueData;
import org.silbertb.proto.domainconverter.util.StringUtils;

public final class EnumData
implements DataWithDefault {
    private final String domainFullName;
    private final String protoFullName;
    private final Collection<EnumValueData> enumValueData;
    private final String domainPackage;
    private final String protoPackage;
    private final boolean isDefault;

    EnumData(String domainFullName, String protoFullName, Collection<EnumValueData> enumValueData, boolean isDefault) {
        this.domainFullName = domainFullName;
        this.protoFullName = protoFullName;
        this.enumValueData = enumValueData;
        this.isDefault = isDefault;
        this.domainPackage = StringUtils.getPackage(domainFullName);
        this.protoPackage = StringUtils.getPackage(protoFullName);
    }

    public static EnumDataBuilder builder() {
        return new EnumDataBuilder();
    }

    @Override
    public String domainFullName() {
        return this.domainFullName;
    }

    public String protoFullName() {
        return this.protoFullName;
    }

    public Collection<EnumValueData> enumValueData() {
        return this.enumValueData;
    }

    public String domainPackage() {
        return this.domainPackage;
    }

    public String protoPackage() {
        return this.protoPackage;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EnumData)) {
            return false;
        }
        EnumData other = (EnumData)o;
        if (this.isDefault() != other.isDefault()) {
            return false;
        }
        String this$domainFullName = this.domainFullName();
        String other$domainFullName = other.domainFullName();
        if (this$domainFullName == null ? other$domainFullName != null : !this$domainFullName.equals(other$domainFullName)) {
            return false;
        }
        String this$protoFullName = this.protoFullName();
        String other$protoFullName = other.protoFullName();
        if (this$protoFullName == null ? other$protoFullName != null : !this$protoFullName.equals(other$protoFullName)) {
            return false;
        }
        Collection<EnumValueData> this$enumValueData = this.enumValueData();
        Collection<EnumValueData> other$enumValueData = other.enumValueData();
        if (this$enumValueData == null ? other$enumValueData != null : !((Object)this$enumValueData).equals(other$enumValueData)) {
            return false;
        }
        String this$domainPackage = this.domainPackage();
        String other$domainPackage = other.domainPackage();
        if (this$domainPackage == null ? other$domainPackage != null : !this$domainPackage.equals(other$domainPackage)) {
            return false;
        }
        String this$protoPackage = this.protoPackage();
        String other$protoPackage = other.protoPackage();
        return !(this$protoPackage == null ? other$protoPackage != null : !this$protoPackage.equals(other$protoPackage));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDefault() ? 79 : 97);
        String $domainFullName = this.domainFullName();
        result = result * 59 + ($domainFullName == null ? 43 : $domainFullName.hashCode());
        String $protoFullName = this.protoFullName();
        result = result * 59 + ($protoFullName == null ? 43 : $protoFullName.hashCode());
        Collection<EnumValueData> $enumValueData = this.enumValueData();
        result = result * 59 + ($enumValueData == null ? 43 : ((Object)$enumValueData).hashCode());
        String $domainPackage = this.domainPackage();
        result = result * 59 + ($domainPackage == null ? 43 : $domainPackage.hashCode());
        String $protoPackage = this.protoPackage();
        result = result * 59 + ($protoPackage == null ? 43 : $protoPackage.hashCode());
        return result;
    }

    public String toString() {
        return "EnumData(domainFullName=" + this.domainFullName() + ", protoFullName=" + this.protoFullName() + ", enumValueData=" + this.enumValueData() + ", domainPackage=" + this.domainPackage() + ", protoPackage=" + this.protoPackage() + ", isDefault=" + this.isDefault() + ")";
    }

    public static class EnumDataBuilder {
        private String domainFullName;
        private String protoFullName;
        private Collection<EnumValueData> enumValueData;
        private boolean isDefault;

        EnumDataBuilder() {
        }

        public EnumDataBuilder domainFullName(String domainFullName) {
            this.domainFullName = domainFullName;
            return this;
        }

        public EnumDataBuilder protoFullName(String protoFullName) {
            this.protoFullName = protoFullName;
            return this;
        }

        public EnumDataBuilder enumValueData(Collection<EnumValueData> enumValueData) {
            this.enumValueData = enumValueData;
            return this;
        }

        public EnumDataBuilder isDefault(boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        public EnumData build() {
            return new EnumData(this.domainFullName, this.protoFullName, this.enumValueData, this.isDefault);
        }

        public String toString() {
            return "EnumData.EnumDataBuilder(domainFullName=" + this.domainFullName + ", protoFullName=" + this.protoFullName + ", enumValueData=" + this.enumValueData + ", isDefault=" + this.isDefault + ")";
        }
    }
}

