/*
 * Decompiled with CFR 0.152.
 */
package org.silbertb.proto.domainconverter.conversion_data;

import org.silbertb.proto.domainconverter.conversion_data.BuilderData;
import org.silbertb.proto.domainconverter.conversion_data.ConcreteFieldData;
import org.silbertb.proto.domainconverter.util.StringUtils;

public class OneofFieldData {
    private final String protoField;
    private final String oneofImplClass;
    private final String converterFullName;
    private final ConcreteFieldData constructorParameter;
    private final ConcreteFieldData fieldData;
    private final BuilderData builderData;

    public String oneofFieldCase() {
        return this.protoField.toUpperCase();
    }

    public String oneOfProtoField() {
        return StringUtils.snakeCaseToPascalCase(this.protoField);
    }

    public String oneofImplVariable() {
        String oneofImplClassSimple = StringUtils.getSimpleName(this.oneofImplClass);
        return StringUtils.pascalCaseToCamelCase(oneofImplClassSimple);
    }

    public boolean mapToDomainField() {
        return this.fieldData != null || this.constructorParameter != null;
    }

    public boolean hasConverter() {
        return this.converterFullName != null;
    }

    public String converterVariable() {
        String converterSimpleName = StringUtils.getSimpleName(this.converterFullName);
        return StringUtils.pascalCaseToCamelCase(converterSimpleName);
    }

    OneofFieldData(String protoField, String oneofImplClass, String converterFullName, ConcreteFieldData constructorParameter, ConcreteFieldData fieldData, BuilderData builderData) {
        this.protoField = protoField;
        this.oneofImplClass = oneofImplClass;
        this.converterFullName = converterFullName;
        this.constructorParameter = constructorParameter;
        this.fieldData = fieldData;
        this.builderData = builderData;
    }

    public static OneofFieldDataBuilder builder() {
        return new OneofFieldDataBuilder();
    }

    public String protoField() {
        return this.protoField;
    }

    public String oneofImplClass() {
        return this.oneofImplClass;
    }

    public String converterFullName() {
        return this.converterFullName;
    }

    public ConcreteFieldData constructorParameter() {
        return this.constructorParameter;
    }

    public ConcreteFieldData fieldData() {
        return this.fieldData;
    }

    public BuilderData builderData() {
        return this.builderData;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OneofFieldData)) {
            return false;
        }
        OneofFieldData other = (OneofFieldData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$protoField = this.protoField();
        String other$protoField = other.protoField();
        if (this$protoField == null ? other$protoField != null : !this$protoField.equals(other$protoField)) {
            return false;
        }
        String this$oneofImplClass = this.oneofImplClass();
        String other$oneofImplClass = other.oneofImplClass();
        if (this$oneofImplClass == null ? other$oneofImplClass != null : !this$oneofImplClass.equals(other$oneofImplClass)) {
            return false;
        }
        String this$converterFullName = this.converterFullName();
        String other$converterFullName = other.converterFullName();
        if (this$converterFullName == null ? other$converterFullName != null : !this$converterFullName.equals(other$converterFullName)) {
            return false;
        }
        ConcreteFieldData this$constructorParameter = this.constructorParameter();
        ConcreteFieldData other$constructorParameter = other.constructorParameter();
        if (this$constructorParameter == null ? other$constructorParameter != null : !((Object)this$constructorParameter).equals(other$constructorParameter)) {
            return false;
        }
        ConcreteFieldData this$fieldData = this.fieldData();
        ConcreteFieldData other$fieldData = other.fieldData();
        if (this$fieldData == null ? other$fieldData != null : !((Object)this$fieldData).equals(other$fieldData)) {
            return false;
        }
        BuilderData this$builderData = this.builderData();
        BuilderData other$builderData = other.builderData();
        return !(this$builderData == null ? other$builderData != null : !this$builderData.equals(other$builderData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OneofFieldData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $protoField = this.protoField();
        result = result * 59 + ($protoField == null ? 43 : $protoField.hashCode());
        String $oneofImplClass = this.oneofImplClass();
        result = result * 59 + ($oneofImplClass == null ? 43 : $oneofImplClass.hashCode());
        String $converterFullName = this.converterFullName();
        result = result * 59 + ($converterFullName == null ? 43 : $converterFullName.hashCode());
        ConcreteFieldData $constructorParameter = this.constructorParameter();
        result = result * 59 + ($constructorParameter == null ? 43 : ((Object)$constructorParameter).hashCode());
        ConcreteFieldData $fieldData = this.fieldData();
        result = result * 59 + ($fieldData == null ? 43 : ((Object)$fieldData).hashCode());
        BuilderData $builderData = this.builderData();
        result = result * 59 + ($builderData == null ? 43 : $builderData.hashCode());
        return result;
    }

    public String toString() {
        return "OneofFieldData(protoField=" + this.protoField() + ", oneofImplClass=" + this.oneofImplClass() + ", converterFullName=" + this.converterFullName() + ", constructorParameter=" + this.constructorParameter() + ", fieldData=" + this.fieldData() + ", builderData=" + this.builderData() + ")";
    }

    public static class OneofFieldDataBuilder {
        private String protoField;
        private String oneofImplClass;
        private String converterFullName;
        private ConcreteFieldData constructorParameter;
        private ConcreteFieldData fieldData;
        private BuilderData builderData;

        OneofFieldDataBuilder() {
        }

        public OneofFieldDataBuilder protoField(String protoField) {
            this.protoField = protoField;
            return this;
        }

        public OneofFieldDataBuilder oneofImplClass(String oneofImplClass) {
            this.oneofImplClass = oneofImplClass;
            return this;
        }

        public OneofFieldDataBuilder converterFullName(String converterFullName) {
            this.converterFullName = converterFullName;
            return this;
        }

        public OneofFieldDataBuilder constructorParameter(ConcreteFieldData constructorParameter) {
            this.constructorParameter = constructorParameter;
            return this;
        }

        public OneofFieldDataBuilder fieldData(ConcreteFieldData fieldData) {
            this.fieldData = fieldData;
            return this;
        }

        public OneofFieldDataBuilder builderData(BuilderData builderData) {
            this.builderData = builderData;
            return this;
        }

        public OneofFieldData build() {
            return new OneofFieldData(this.protoField, this.oneofImplClass, this.converterFullName, this.constructorParameter, this.fieldData, this.builderData);
        }

        public String toString() {
            return "OneofFieldData.OneofFieldDataBuilder(protoField=" + this.protoField + ", oneofImplClass=" + this.oneofImplClass + ", converterFullName=" + this.converterFullName + ", constructorParameter=" + this.constructorParameter + ", fieldData=" + this.fieldData + ", builderData=" + this.builderData + ")";
        }
    }
}

