/*
 * Decompiled with CFR 0.152.
 */
package org.silbertb.proto.domainconverter.conversion_data;

import org.silbertb.proto.domainconverter.conversion_data.ClassData;
import org.silbertb.proto.domainconverter.util.StringUtils;

public class OneofFieldDataForClass {
    private final String protoField;
    private final boolean isMessage;
    private final ClassData classData;

    public String oneofImplClass() {
        return this.classData.domainFullName();
    }

    public String oneOfProtoField() {
        return StringUtils.snakeCaseToPascalCase(this.protoField);
    }

    public String oneofFieldCase() {
        return this.protoField.toUpperCase();
    }

    OneofFieldDataForClass(String protoField, boolean isMessage, ClassData classData) {
        this.protoField = protoField;
        this.isMessage = isMessage;
        this.classData = classData;
    }

    public static OneofFieldDataForClassBuilder builder() {
        return new OneofFieldDataForClassBuilder();
    }

    public String protoField() {
        return this.protoField;
    }

    public boolean isMessage() {
        return this.isMessage;
    }

    public ClassData classData() {
        return this.classData;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OneofFieldDataForClass)) {
            return false;
        }
        OneofFieldDataForClass other = (OneofFieldDataForClass)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isMessage() != other.isMessage()) {
            return false;
        }
        String this$protoField = this.protoField();
        String other$protoField = other.protoField();
        if (this$protoField == null ? other$protoField != null : !this$protoField.equals(other$protoField)) {
            return false;
        }
        ClassData this$classData = this.classData();
        ClassData other$classData = other.classData();
        return !(this$classData == null ? other$classData != null : !((Object)this$classData).equals(other$classData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OneofFieldDataForClass;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isMessage() ? 79 : 97);
        String $protoField = this.protoField();
        result = result * 59 + ($protoField == null ? 43 : $protoField.hashCode());
        ClassData $classData = this.classData();
        result = result * 59 + ($classData == null ? 43 : ((Object)$classData).hashCode());
        return result;
    }

    public String toString() {
        return "OneofFieldDataForClass(protoField=" + this.protoField() + ", isMessage=" + this.isMessage() + ", classData=" + this.classData() + ")";
    }

    public static class OneofFieldDataForClassBuilder {
        private String protoField;
        private boolean isMessage;
        private ClassData classData;

        OneofFieldDataForClassBuilder() {
        }

        public OneofFieldDataForClassBuilder protoField(String protoField) {
            this.protoField = protoField;
            return this;
        }

        public OneofFieldDataForClassBuilder isMessage(boolean isMessage) {
            this.isMessage = isMessage;
            return this;
        }

        public OneofFieldDataForClassBuilder classData(ClassData classData) {
            this.classData = classData;
            return this;
        }

        public OneofFieldDataForClass build() {
            return new OneofFieldDataForClass(this.protoField, this.isMessage, this.classData);
        }

        public String toString() {
            return "OneofFieldDataForClass.OneofFieldDataForClassBuilder(protoField=" + this.protoField + ", isMessage=" + this.isMessage + ", classData=" + this.classData + ")";
        }
    }
}

