/*
 * Decompiled with CFR 0.152.
 */
package org.silbertb.proto.domainconverter.converter;

import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.silbertb.proto.domainconverter.annotations.ProtoBuilder;
import org.silbertb.proto.domainconverter.conversion_data.BuilderData;
import org.silbertb.proto.domainconverter.conversion_data.FieldData;
import org.silbertb.proto.domainconverter.converter.ConstructorParametersDataCreator;

public class BuilderDataCreator {
    private final ConstructorParametersDataCreator constructorParametersDataCreator;

    public BuilderDataCreator(ConstructorParametersDataCreator constructorParametersDataCreator) {
        this.constructorParametersDataCreator = constructorParametersDataCreator;
    }

    public BuilderData createClassLevelBuilderData(TypeElement domainElement) {
        ProtoBuilder protoBuilderAnnotation = domainElement.getAnnotation(ProtoBuilder.class);
        return protoBuilderAnnotation == null ? null : this.createBuilderData(protoBuilderAnnotation, false);
    }

    public BuilderData getConstructorBuilderData(TypeElement domainElement) {
        List constructors = domainElement.getEnclosedElements().stream().filter(e -> e.getKind().equals((Object)ElementKind.CONSTRUCTOR)).collect(Collectors.toList());
        for (Element constructor : constructors) {
            ProtoBuilder protoBuilderAnnotation = constructor.getAnnotation(ProtoBuilder.class);
            if (protoBuilderAnnotation == null) continue;
            return this.createBuilderData(protoBuilderAnnotation, true);
        }
        return null;
    }

    public List<FieldData> createBuilderConstructorParametersData(TypeElement domainElement) {
        return this.constructorParametersDataCreator.getConstructorParametersData(domainElement, ProtoBuilder.class);
    }

    private BuilderData createBuilderData(ProtoBuilder protoBuilderAnnotation, boolean constructorAnnotation) {
        return BuilderData.builder().builderMethodName(protoBuilderAnnotation.builderMethodName()).buildMethodName(protoBuilderAnnotation.buildMethodName()).setterPrefix(protoBuilderAnnotation.setterPrefix()).useConstructorParams(constructorAnnotation).build();
    }
}

