/*
 * Decompiled with CFR 0.152.
 */
package org.silbertb.proto.domainconverter.converter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.silbertb.proto.domainconverter.annotations.OneofBase;
import org.silbertb.proto.domainconverter.annotations.ProtoClass;
import org.silbertb.proto.domainconverter.annotations.ProtoClassDefault;
import org.silbertb.proto.domainconverter.annotations.ProtoClassMapper;
import org.silbertb.proto.domainconverter.annotations.ProtoConstructor;
import org.silbertb.proto.domainconverter.conversion_data.BuilderData;
import org.silbertb.proto.domainconverter.conversion_data.ClassData;
import org.silbertb.proto.domainconverter.conversion_data.ConfigurationData;
import org.silbertb.proto.domainconverter.conversion_data.FieldData;
import org.silbertb.proto.domainconverter.converter.BuilderDataCreator;
import org.silbertb.proto.domainconverter.converter.ConcreteFieldDataCreator;
import org.silbertb.proto.domainconverter.converter.ConstructorParametersDataCreator;
import org.silbertb.proto.domainconverter.converter.ConverterLogger;
import org.silbertb.proto.domainconverter.converter.FieldDataCreator;
import org.silbertb.proto.domainconverter.converter.GlobalMapperInfo;
import org.silbertb.proto.domainconverter.converter.OneofBaseDataCreator;
import org.silbertb.proto.domainconverter.custom.NullMapper;
import org.silbertb.proto.domainconverter.util.LangModelUtil;
import org.silbertb.proto.domainconverter.util.ProtoTypeUtil;

public class ClassDataCreator {
    private final LangModelUtil langModelUtil;
    private final OneofBaseDataCreator oneofBaseDataCreator;
    private final ConstructorParametersDataCreator constructorParametersDataCreator;
    private final BuilderDataCreator builderDataCreator;
    private final FieldDataCreator fieldDataCreator;

    public ClassDataCreator(LangModelUtil langModelUtil, ProcessingEnvironment processingEnv, ProtoTypeUtil protoTypeUtil, ConverterLogger logger, ConfigurationData configurationData, Set<String> domainFieldsWithGlobalMappers) {
        this.langModelUtil = langModelUtil;
        ConcreteFieldDataCreator concreteFieldDataCreator = new ConcreteFieldDataCreator(langModelUtil, protoTypeUtil, logger, configurationData, domainFieldsWithGlobalMappers);
        this.oneofBaseDataCreator = new OneofBaseDataCreator(langModelUtil, protoTypeUtil, processingEnv, logger, this);
        this.constructorParametersDataCreator = new ConstructorParametersDataCreator(concreteFieldDataCreator, this.oneofBaseDataCreator);
        this.builderDataCreator = new BuilderDataCreator(this.constructorParametersDataCreator);
        this.fieldDataCreator = new FieldDataCreator(processingEnv, concreteFieldDataCreator, this.oneofBaseDataCreator);
        this.oneofBaseDataCreator.setConstructorParametersDataCreator(this.constructorParametersDataCreator);
        this.oneofBaseDataCreator.setBuilderDataCreator(this.builderDataCreator);
        this.oneofBaseDataCreator.setFieldDataCreator(this.fieldDataCreator);
    }

    public ClassData createClassData(TypeElement domainElement) {
        ProtoClass protoClassAnnotation = domainElement.getAnnotation(ProtoClass.class);
        TypeMirror protoClass = this.langModelUtil.getClassFromAnnotation(protoClassAnnotation::protoClass);
        String mapperFullName = this.getCustomMapper(protoClassAnnotation);
        boolean withInheritedFields = protoClassAnnotation.withInheritedFields();
        return this.createClassData(domainElement, protoClass, withInheritedFields, mapperFullName, protoClassAnnotation.blacklist());
    }

    public ClassData createClassData(GlobalMapperInfo globalMapperTypes) {
        return ClassData.builder().domainFullName(globalMapperTypes.getDomainName()).protoFullName(globalMapperTypes.getProtoName()).mapperFullName(globalMapperTypes.getMapperName()).isDefault(globalMapperTypes.isDefault()).build();
    }

    public ClassData createClassData(TypeElement domainElement, TypeMirror protoClass, boolean withInheritedFields, boolean blacklist) {
        return this.createClassData(domainElement, protoClass, withInheritedFields, null, blacklist);
    }

    private ClassData createClassData(TypeElement domainElement, TypeMirror protoClass, boolean withInheritedFields, String mapperFullNameFromProtoClassAnnotation, boolean blacklist) {
        ProtoClassMapper mapperAnnotation;
        ClassData.ClassDataBuilder classDataBuilder = ClassData.builder().domainFullName(domainElement.getQualifiedName().toString()).protoFullName(protoClass.toString());
        String mapperFullName = null;
        if (mapperFullNameFromProtoClassAnnotation == null && (mapperAnnotation = domainElement.getAnnotation(ProtoClassMapper.class)) != null) {
            mapperFullName = this.getCustomMapper(mapperAnnotation);
        }
        BuilderData builderData = this.builderDataCreator.createClassLevelBuilderData(domainElement);
        List<FieldData> constructorParametersData = this.constructorParametersDataCreator.getConstructorParametersData(domainElement, ProtoConstructor.class, Modifier.PUBLIC);
        List<FieldData> builderConstructorParametersData = this.builderDataCreator.createBuilderConstructorParametersData(domainElement);
        this.validateAnnotations(domainElement, mapperFullName, builderData, constructorParametersData, builderConstructorParametersData);
        if (mapperFullName != null) {
            return classDataBuilder.mapperFullName(mapperFullName).constructorParameters(Collections.emptyList()).fieldsData(Collections.emptyList()).build();
        }
        ArrayList<FieldData> fieldsData = this.fieldDataCreator.getFieldData(domainElement, withInheritedFields, blacklist);
        if (constructorParametersData != null) {
            classDataBuilder.constructorParameters(constructorParametersData);
            fieldsData = this.removeFormFieldData(fieldsData, constructorParametersData);
        }
        if (builderConstructorParametersData != null) {
            classDataBuilder.constructorParameters(builderConstructorParametersData);
            builderData = this.builderDataCreator.getConstructorBuilderData(domainElement);
            fieldsData = this.removeFormFieldData(fieldsData, builderConstructorParametersData);
        }
        classDataBuilder.builderData(builderData);
        classDataBuilder.fieldsData(fieldsData);
        OneofBase oneofBaseAnnotation = domainElement.getAnnotation(OneofBase.class);
        classDataBuilder.oneofBaseClassData(this.oneofBaseDataCreator.createOneofBaseClassData(oneofBaseAnnotation, protoClass, blacklist));
        ProtoClassDefault protoClassDefaultAnnotation = domainElement.getAnnotation(ProtoClassDefault.class);
        if (protoClassDefaultAnnotation != null) {
            classDataBuilder.isDefault(true);
        }
        return classDataBuilder.build();
    }

    private ArrayList<FieldData> removeFormFieldData(List<FieldData> fieldDataList, List<FieldData> fieldsToRemove) {
        String domainFieldName;
        LinkedHashMap<String, FieldData> fieldDataMap = new LinkedHashMap<String, FieldData>();
        for (FieldData fieldData : fieldDataList) {
            domainFieldName = this.getDomainFieldName(fieldData);
            fieldDataMap.put(domainFieldName, fieldData);
        }
        for (FieldData fieldData : fieldsToRemove) {
            domainFieldName = this.getDomainFieldName(fieldData);
            fieldDataMap.remove(domainFieldName);
        }
        ArrayList<FieldData> remainingFields = new ArrayList<FieldData>(fieldDataMap.values());
        if (!remainingFields.isEmpty()) {
            FieldData last = remainingFields.get(remainingFields.size() - 1);
            FieldData newLast = FieldData.builder().concreteFieldData(last.concreteFieldData()).oneofFieldData(last.oneofFieldData()).isLast(true).build();
            remainingFields.set(remainingFields.size() - 1, newLast);
        }
        return remainingFields;
    }

    private String getDomainFieldName(FieldData fieldData) {
        return fieldData.concreteFieldData() == null ? fieldData.oneofFieldData().domainFieldName() : fieldData.concreteFieldData().domainFieldName();
    }

    private void validateAnnotations(TypeElement domainElement, String mapperFullName, BuilderData classLevelBuilderData, List<FieldData> constructorParametersData, List<FieldData> builderConstructorParametersData) {
        if (mapperFullName != null) {
            if (classLevelBuilderData != null || builderConstructorParametersData != null) {
                throw new IllegalArgumentException("Both annotations are used:  @ProtoClassMapper and @ProtoBuilder. class: " + domainElement);
            }
            if (constructorParametersData != null) {
                throw new IllegalArgumentException("Both annotations are used:  @ProtoClassMapper and @ProtoConstructor. class: " + domainElement);
            }
        }
        if (constructorParametersData != null && builderConstructorParametersData != null) {
            throw new IllegalArgumentException("Both annotations are used on constructors:  @ProtoConstructor and @ProtoBuilder. class: " + domainElement);
        }
        if (classLevelBuilderData != null && builderConstructorParametersData != null) {
            throw new IllegalArgumentException("@ProtoBuilder annotation is used both in class context and in constructor context. class: " + domainElement);
        }
    }

    private String getCustomMapper(ProtoClass protoClassAnnotation) {
        TypeMirror mapperClass = this.langModelUtil.getClassFromAnnotation(protoClassAnnotation::mapper);
        String mapperFullName = mapperClass.toString();
        if (mapperFullName.equals(NullMapper.class.getName())) {
            return null;
        }
        return mapperFullName;
    }

    private String getCustomMapper(ProtoClassMapper protoMapperAnnotation) {
        TypeMirror mapperClass = this.langModelUtil.getClassFromAnnotation(protoMapperAnnotation::mapper);
        return mapperClass.toString();
    }
}

