/*
 * Decompiled with CFR 0.152.
 */
package org.silbertb.proto.domainconverter.converter;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.silbertb.proto.domainconverter.annotations.OneofBase;
import org.silbertb.proto.domainconverter.annotations.ProtoField;
import org.silbertb.proto.domainconverter.conversion_data.ConcreteFieldData;
import org.silbertb.proto.domainconverter.conversion_data.FieldData;
import org.silbertb.proto.domainconverter.conversion_data.OneofBaseFieldData;
import org.silbertb.proto.domainconverter.converter.ConcreteFieldDataCreator;
import org.silbertb.proto.domainconverter.converter.OneofBaseDataCreator;

public class ConstructorParametersDataCreator {
    private final ConcreteFieldDataCreator concreteFieldDataCreator;
    private final OneofBaseDataCreator oneofBaseDataCreator;

    public ConstructorParametersDataCreator(ConcreteFieldDataCreator concreteFieldDataCreator, OneofBaseDataCreator oneofBaseDataCreator) {
        this.concreteFieldDataCreator = concreteFieldDataCreator;
        this.oneofBaseDataCreator = oneofBaseDataCreator;
    }

    public <A extends Annotation> List<FieldData> getConstructorParametersData(TypeElement domainElement, Class<A> constructorAnnotationClass) {
        return this.getConstructorParametersData(domainElement, constructorAnnotationClass, null);
    }

    public <A extends Annotation> List<FieldData> getConstructorParametersData(TypeElement domainElement, Class<A> constructorAnnotationClass, Modifier modifier) {
        List constructors = domainElement.getEnclosedElements().stream().filter(e -> e.getKind().equals((Object)ElementKind.CONSTRUCTOR) && (modifier == null || e.getModifiers().contains((Object)modifier))).collect(Collectors.toList());
        List<FieldData> constructorParameters = null;
        for (Element constructor : constructors) {
            A protoConstructorAnnotation = constructor.getAnnotation(constructorAnnotationClass);
            if (protoConstructorAnnotation == null) continue;
            if (constructorParameters != null) {
                throw new IllegalArgumentException("More than one constructors are annotated with @ProtoConstructor. class: " + domainElement);
            }
            constructorParameters = this.getConstructorParams((ExecutableElement)constructor);
        }
        return constructorParameters;
    }

    private List<FieldData> getConstructorParams(ExecutableElement constructor) {
        ArrayList<FieldData> constructorParameters = new ArrayList<FieldData>();
        for (VariableElement variableElement : constructor.getParameters()) {
            ProtoField protoFieldAnnotation = variableElement.getAnnotation(ProtoField.class);
            OneofBase oneofBaseAnnotation = variableElement.getAnnotation(OneofBase.class);
            if (protoFieldAnnotation != null && oneofBaseAnnotation != null) {
                throw new IllegalArgumentException("constructor parameter is annotated with both 'ProtoField' and 'OneofField'. param: " + variableElement);
            }
            if (oneofBaseAnnotation == null) {
                String explicitProtoFieldName = protoFieldAnnotation == null ? "" : protoFieldAnnotation.protoName();
                ConcreteFieldData concreteFieldData = this.concreteFieldDataCreator.createFieldData(variableElement, explicitProtoFieldName);
                FieldData parameterData = FieldData.builder().concreteFieldData(concreteFieldData).build();
                constructorParameters.add(parameterData);
                continue;
            }
            OneofBaseFieldData oneofBaseFieldData = this.oneofBaseDataCreator.createOneofBaseFieldData(variableElement);
            FieldData parameterData = FieldData.builder().oneofFieldData(oneofBaseFieldData).build();
            constructorParameters.add(parameterData);
        }
        if (constructorParameters.size() > 0) {
            FieldData lastElement = (FieldData)constructorParameters.get(constructorParameters.size() - 1);
            FieldData fieldData = FieldData.builder().concreteFieldData(lastElement.concreteFieldData()).oneofFieldData(lastElement.oneofFieldData()).isLast(true).build();
            constructorParameters.set(constructorParameters.size() - 1, fieldData);
        }
        return constructorParameters;
    }
}

