/*
 * Decompiled with CFR 0.152.
 */
package org.silbertb.proto.domainconverter.converter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.TypeElement;
import org.silbertb.proto.domainconverter.annotations.ProtoClass;
import org.silbertb.proto.domainconverter.annotations.ProtoEnum;
import org.silbertb.proto.domainconverter.annotations.ProtoGlobalMapper;
import org.silbertb.proto.domainconverter.conversion_data.ClassData;
import org.silbertb.proto.domainconverter.conversion_data.ConfigurationData;
import org.silbertb.proto.domainconverter.conversion_data.ConversionData;
import org.silbertb.proto.domainconverter.conversion_data.DataWithDefault;
import org.silbertb.proto.domainconverter.conversion_data.EnumData;
import org.silbertb.proto.domainconverter.converter.ClassDataCreator;
import org.silbertb.proto.domainconverter.converter.ConfigurationCreator;
import org.silbertb.proto.domainconverter.converter.ConverterLogger;
import org.silbertb.proto.domainconverter.converter.EnumDataCreator;
import org.silbertb.proto.domainconverter.converter.GlobalMapperInfo;
import org.silbertb.proto.domainconverter.converter.GlobalMapperTypesCreator;
import org.silbertb.proto.domainconverter.util.LangModelUtil;
import org.silbertb.proto.domainconverter.util.ProtoTypeUtil;

public class ConversionDataCreator {
    private final ProcessingEnvironment processingEnv;
    private final LangModelUtil langModelUtil;
    private final ConverterLogger logger;

    public ConversionDataCreator(ProcessingEnvironment processingEnv, ConverterLogger logger) {
        this.processingEnv = processingEnv;
        this.logger = logger;
        this.langModelUtil = new LangModelUtil(processingEnv);
    }

    public ConversionData createConversionData(RoundEnvironment roundEnv) {
        LangModelUtil langModelUtil = new LangModelUtil(this.processingEnv);
        ProtoTypeUtil protoTypeUtil = new ProtoTypeUtil(this.processingEnv, langModelUtil);
        ConfigurationCreator configurationCreator = new ConfigurationCreator(this.processingEnv, langModelUtil);
        ConfigurationData configurationData = configurationCreator.createConfigurationData(roundEnv);
        List<GlobalMapperInfo> globalMappers = this.findGlobalMappers(roundEnv);
        List<GlobalMapperInfo> predefinedGlobalMappers = this.getPredefinedGlobalMappers();
        Set<String> domainFieldsWithGlobalMappers = Stream.concat(globalMappers.stream(), predefinedGlobalMappers.stream()).map(GlobalMapperInfo::getDomainName).collect(Collectors.toSet());
        domainFieldsWithGlobalMappers.forEach(domainField -> configurationData.domainClassToConverter().remove(domainField));
        ClassDataCreator classDataCreator = new ClassDataCreator(langModelUtil, this.processingEnv, protoTypeUtil, this.logger, configurationData, domainFieldsWithGlobalMappers);
        ConversionData.ConversionDataBuilder conversionData = ConversionData.builder().generator(this.getClass().getName()).converterFullName(configurationData.generatedConverterName());
        List<EnumData> enumDataList = this.createEnumData(roundEnv);
        Map protoToDomainClasses = this.createClassesDataFromProtoClass(roundEnv, classDataCreator);
        Map<String, List<ClassData>> protoToDomainClassFromGlobalMappers = this.createClassesData(globalMappers, classDataCreator);
        this.mergeClassDataMap(protoToDomainClasses, protoToDomainClassFromGlobalMappers, false);
        Map<String, List<ClassData>> protoToDomainClassFromPredefinedGlobalMappers = this.createClassesData(predefinedGlobalMappers, classDataCreator);
        this.mergeClassDataMap(protoToDomainClasses, protoToDomainClassFromPredefinedGlobalMappers, true);
        List<ClassData> defaultDomainClasses = this.getDefaultDomainClasses(protoToDomainClasses);
        List<EnumData> defaultEnumsData = this.getDefaultDomainClasses(enumDataList.stream().collect(Collectors.groupingBy(EnumData::protoFullName)));
        return conversionData.configurationData(configurationData).classesData(protoToDomainClasses.values().stream().flatMap(Collection::stream).collect(Collectors.toUnmodifiableList())).defaultClassesData(defaultDomainClasses).enumData(enumDataList).defaultEnumsData(defaultEnumsData).build();
    }

    private List<GlobalMapperInfo> getPredefinedGlobalMappers() {
        return this.getPredefinedGlobalMappers("org.silbertb.proto.domainconverter.predefined_mappers.InstantTimestampMapper");
    }

    private List<GlobalMapperInfo> getPredefinedGlobalMappers(String ... classNames) {
        GlobalMapperTypesCreator creator = new GlobalMapperTypesCreator(this.langModelUtil);
        return Arrays.stream(classNames).map(className -> this.processingEnv.getElementUtils().getTypeElement((CharSequence)className)).map(creator::create).collect(Collectors.toList());
    }

    private void mergeClassDataMap(Map<String, List<ClassData>> classDataFromProtoClass, Map<String, List<ClassData>> classDataFromGlobalMapper, boolean ignoreIfExists) {
        for (Map.Entry<String, List<ClassData>> e : classDataFromGlobalMapper.entrySet()) {
            List<ClassData> merged = this.mergeClassDataLists(classDataFromProtoClass.get(e.getKey()), e.getValue(), ignoreIfExists);
            classDataFromProtoClass.put(e.getKey(), merged);
        }
    }

    private List<ClassData> mergeClassDataLists(List<ClassData> l1, List<ClassData> l2, boolean ignoreIfExists) {
        HashMap<String, ClassData> domainClassToClassData = new HashMap<String, ClassData>();
        if (l1 != null) {
            for (ClassData classData : l1) {
                domainClassToClassData.put(classData.domainFullName(), classData);
            }
        }
        if (l2 != null) {
            for (ClassData classData : l2) {
                if (domainClassToClassData.containsKey(classData.domainFullName())) {
                    if (ignoreIfExists) continue;
                    throw new IllegalArgumentException("Both @ProtoClass and @ProtoGlobalMapper are defined to the same proto message and domain class. proto: " + classData.protoFullName() + " domain: " + classData.domainFullName());
                }
                domainClassToClassData.put(classData.domainFullName(), classData);
            }
        }
        return new ArrayList<ClassData>(domainClassToClassData.values());
    }

    private List<GlobalMapperInfo> findGlobalMappers(RoundEnvironment roundEnv) {
        GlobalMapperTypesCreator creator = new GlobalMapperTypesCreator(this.langModelUtil);
        return roundEnv.getElementsAnnotatedWith(ProtoGlobalMapper.class).stream().map(e -> creator.create((TypeElement)e)).collect(Collectors.toList());
    }

    private Map<String, List<ClassData>> createClassesData(List<GlobalMapperInfo> globalMappersInfo, ClassDataCreator classDataCreator) {
        return globalMappersInfo.stream().map(classDataCreator::createClassData).collect(Collectors.groupingBy(ClassData::protoFullName));
    }

    private Map<String, List<ClassData>> createClassesDataFromProtoClass(RoundEnvironment roundEnv, ClassDataCreator classDataCreator) {
        return roundEnv.getElementsAnnotatedWith(ProtoClass.class).stream().map(element -> (TypeElement)element).map(classDataCreator::createClassData).collect(Collectors.groupingBy(ClassData::protoFullName));
    }

    private <T extends DataWithDefault> List<T> getDefaultDomainClasses(Map<String, List<T>> protoToDomainClass) {
        return protoToDomainClass.values().stream().map(this::getDefault).flatMap(Optional::stream).collect(Collectors.toUnmodifiableList());
    }

    private <T extends DataWithDefault> Optional<T> getDefault(List<T> dataWithDefault) {
        if (dataWithDefault.size() == 1) {
            return Optional.of((DataWithDefault)dataWithDefault.get(0));
        }
        List defaults = dataWithDefault.stream().filter(DataWithDefault::isDefault).collect(Collectors.toUnmodifiableList());
        if (defaults.size() > 1) {
            throw new IllegalArgumentException("More than one default class exists for proto '" + ((DataWithDefault)dataWithDefault.get(0)).domainFullName() + "'.");
        }
        if (defaults.size() == 1) {
            return Optional.of((DataWithDefault)defaults.get(0));
        }
        return Optional.empty();
    }

    private List<EnumData> createEnumData(RoundEnvironment roundEnv) {
        EnumDataCreator enumDataCreator = new EnumDataCreator(this.langModelUtil, this.processingEnv, this.logger);
        return roundEnv.getElementsAnnotatedWith(ProtoEnum.class).stream().map(element -> (TypeElement)element).map(enumDataCreator::createEnumData).collect(Collectors.toList());
    }
}

