/*
 * Decompiled with CFR 0.152.
 */
package org.silbertb.proto.domainconverter.converter;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import org.silbertb.proto.domainconverter.conversion_data.ConcreteFieldData;
import org.silbertb.proto.domainconverter.conversion_data.FieldData;
import org.silbertb.proto.domainconverter.conversion_data.OneofBaseFieldData;
import org.silbertb.proto.domainconverter.converter.ConcreteFieldDataCreator;
import org.silbertb.proto.domainconverter.converter.OneofBaseDataCreator;

public class FieldDataCreator {
    private final ProcessingEnvironment processingEnv;
    private final ConcreteFieldDataCreator concreteFieldDataCreator;
    private final OneofBaseDataCreator oneofBaseDataCreator;

    public FieldDataCreator(ProcessingEnvironment processingEnv, ConcreteFieldDataCreator concreteFieldDataCreator, OneofBaseDataCreator oneofBaseDataCreator) {
        this.processingEnv = processingEnv;
        this.concreteFieldDataCreator = concreteFieldDataCreator;
        this.oneofBaseDataCreator = oneofBaseDataCreator;
    }

    public ArrayList<FieldData> getFieldData(TypeElement domainElement, boolean withInheritedFields, boolean blacklist) {
        ArrayList<FieldData> fieldsData = new ArrayList<FieldData>();
        for (Element field : this.getDomainFields(domainElement, withInheritedFields)) {
            OneofBaseFieldData oneofBaseFieldData;
            FieldData.FieldDataBuilder fieldDataBuilder = FieldData.builder();
            ConcreteFieldData concreteFieldData = this.concreteFieldDataCreator.createFieldData((VariableElement)field, blacklist);
            if (concreteFieldData != null) {
                fieldDataBuilder.concreteFieldData(concreteFieldData).build();
            }
            if ((oneofBaseFieldData = this.oneofBaseDataCreator.createOneofBaseFieldData((VariableElement)field)) != null) {
                fieldDataBuilder.oneofFieldData(oneofBaseFieldData);
            }
            if (concreteFieldData != null && oneofBaseFieldData != null) {
                throw new IllegalArgumentException("field is annotated with both 'ProtoField' and 'OneofField'. field: " + field);
            }
            if (concreteFieldData == null && oneofBaseFieldData == null) continue;
            fieldsData.add(fieldDataBuilder.build());
        }
        return fieldsData;
    }

    private List<Element> getDomainFields(TypeElement domainElement, boolean withInheritedFields) {
        List<Element> fields = domainElement.getEnclosedElements().stream().filter(e -> e.getKind().equals((Object)ElementKind.FIELD)).filter(e -> !e.getModifiers().contains((Object)Modifier.STATIC)).collect(Collectors.toList());
        if (withInheritedFields && domainElement.getSuperclass().getKind() == TypeKind.DECLARED) {
            TypeElement superclass = (TypeElement)this.processingEnv.getTypeUtils().asElement(domainElement.getSuperclass());
            fields.addAll(this.getDomainFields(superclass, true));
        }
        return fields;
    }
}

