/*
 * Decompiled with CFR 0.152.
 */
package org.silbertb.proto.domainconverter.converter;

import java.util.List;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.silbertb.proto.domainconverter.annotations.ProtoClassDefault;
import org.silbertb.proto.domainconverter.converter.GlobalMapperInfo;
import org.silbertb.proto.domainconverter.custom.Mapper;
import org.silbertb.proto.domainconverter.util.LangModelUtil;

public class GlobalMapperTypesCreator {
    private final LangModelUtil langModelUtil;

    public GlobalMapperTypesCreator(LangModelUtil langModelUtil) {
        this.langModelUtil = langModelUtil;
    }

    public GlobalMapperInfo create(TypeElement globalMapper) {
        String mapperFullName = globalMapper.getQualifiedName().toString();
        TypeMirror globalMapperType = globalMapper.asType();
        if (!this.langModelUtil.isAssignedFrom(globalMapperType, Mapper.class)) {
            throw new RuntimeException(mapperFullName + " is annotated with '@ProtoGlobalMapper' but not implements 'Mapper'");
        }
        TypeMirror mapperInterface = this.langModelUtil.getInterfaceOf(globalMapperType, Mapper.class.getName());
        List<? extends TypeMirror> genericTypes = this.langModelUtil.getGenericsTypes(mapperInterface);
        String domainFullName = genericTypes.get(0).toString();
        String protoFullName = genericTypes.get(1).toString();
        ProtoClassDefault protoClassDefaultAnnotation = globalMapper.getAnnotation(ProtoClassDefault.class);
        boolean isDefault = protoClassDefaultAnnotation != null;
        return new GlobalMapperInfo(mapperFullName, domainFullName, protoFullName, isDefault);
    }
}

