/*
 * Decompiled with CFR 0.152.
 */
package org.silbertb.proto.domainconverter.converter;

import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.type.TypeMirror;
import org.silbertb.proto.domainconverter.annotations.OneofField;
import org.silbertb.proto.domainconverter.util.LangModelUtil;
import org.silbertb.proto.domainconverter.util.TypeHierarchyComparator;

public class OneofFieldComparator
implements Comparator<OneofField> {
    private final TypeHierarchyComparator typeHierarchyComparator;
    private final LangModelUtil langModelUtil;
    private final Map<OneofField, TypeMirror> domainClassByOneofField;

    public OneofFieldComparator(ProcessingEnvironment processingEnv, LangModelUtil langModelUtil) {
        this.typeHierarchyComparator = new TypeHierarchyComparator(processingEnv.getTypeUtils());
        this.langModelUtil = langModelUtil;
        this.domainClassByOneofField = new IdentityHashMap<OneofField, TypeMirror>();
    }

    @Override
    public int compare(OneofField a, OneofField b) {
        return this.typeHierarchyComparator.compare(this.getType(a), this.getType(b));
    }

    public TypeMirror getType(OneofField oneofField) {
        return this.domainClassByOneofField.computeIfAbsent(oneofField, oneofField1 -> this.langModelUtil.getClassFromAnnotation(oneofField1::domainClass));
    }
}

