/*
 * Decompiled with CFR 0.152.
 */
package org.silbertb.proto.domainconverter.util;

import com.google.protobuf.Message;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

public class LangModelUtil {
    private final ProcessingEnvironment processingEnv;

    public LangModelUtil(ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
    }

    public TypeMirror getClassFromAnnotation(Runnable classGetterFromAnnotation) {
        try {
            classGetterFromAnnotation.run();
        }
        catch (MirroredTypeException mte) {
            return mte.getTypeMirror();
        }
        return null;
    }

    public VariableElement getMemberField(TypeMirror typeMirror, String fieldName) {
        for (Element element : this.processingEnv.getTypeUtils().asElement(typeMirror).getEnclosedElements()) {
            if (!element.getKind().equals((Object)ElementKind.FIELD) || !element.getSimpleName().contentEquals(fieldName)) continue;
            return (VariableElement)element;
        }
        return null;
    }

    public boolean isList(TypeMirror typeMirror) {
        return this.isAssignedFrom(typeMirror, List.class);
    }

    public boolean isMap(TypeMirror typeMirror) {
        return this.isAssignedFrom(typeMirror, Map.class);
    }

    public boolean isMessage(TypeMirror typeMirror) {
        return this.isAssignedFrom(typeMirror, Message.class);
    }

    public boolean isAssignedFrom(TypeMirror typeMirror, Class<?> supposedSuperClass) {
        String superClassName = supposedSuperClass.getName();
        TypeElement superTypeElement = this.processingEnv.getElementUtils().getTypeElement(superClassName);
        Types typeUtil = this.processingEnv.getTypeUtils();
        return typeUtil.isAssignable(typeMirror, typeUtil.erasure(superTypeElement.asType()));
    }

    public boolean isConcreteType(Element element) {
        Element e = this.processingEnv.getTypeUtils().asElement(element.asType());
        return !this.isAbstractType(e) && !this.isInterfaceType(e);
    }

    public boolean isAbstractType(Element element) {
        return element.getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    public boolean isInterfaceType(Element element) {
        return element.getKind() == ElementKind.INTERFACE;
    }

    public boolean isSameType(TypeMirror typeMirror, Class<?> clazz) {
        TypeElement otherTypeElement = this.processingEnv.getElementUtils().getTypeElement(clazz.getName());
        Types typeUtil = this.processingEnv.getTypeUtils();
        return typeUtil.isSameType(typeMirror, otherTypeElement.asType());
    }

    public boolean isByteArray(TypeMirror typeMirror) {
        if (typeMirror.getKind() == TypeKind.ARRAY) {
            return ((ArrayType)typeMirror).getComponentType().getKind().equals((Object)TypeKind.BYTE);
        }
        return false;
    }

    public <A extends Annotation> A getAnnotation(TypeMirror typeMirror, Class<A> annotationClass) {
        Types typeUtils = this.processingEnv.getTypeUtils();
        TypeElement typeElement = (TypeElement)typeUtils.asElement(typeMirror);
        return typeElement.getAnnotation(annotationClass);
    }

    public List<? extends TypeMirror> getGenericsTypes(TypeMirror typeMirror) {
        if (!typeMirror.getKind().equals((Object)TypeKind.DECLARED)) {
            return Collections.emptyList();
        }
        DeclaredType fieldDeclaredType = (DeclaredType)typeMirror;
        return fieldDeclaredType.getTypeArguments();
    }

    public TypeMirror getInterfaceOf(TypeMirror typeMirror, String interfaceName) {
        if (this.processingEnv.getTypeUtils().erasure(typeMirror).toString().equals(interfaceName)) {
            return typeMirror;
        }
        for (TypeMirror typeMirror2 : this.processingEnv.getTypeUtils().directSupertypes(typeMirror)) {
            TypeMirror result = this.getInterfaceOf(typeMirror2, interfaceName);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public List<ExecutableElement> getAllMethods(TypeElement typeElement) {
        return typeElement.getEnclosedElements().stream().filter(e -> e.getKind().equals((Object)ElementKind.METHOD)).map(e -> (ExecutableElement)e).collect(Collectors.toList());
    }

    private void info(String msg) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, msg);
    }
}

