/*
 * Decompiled with CFR 0.152.
 */
package org.silbertb.proto.domainconverter.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.silbertb.proto.domainconverter.annotations.ProtoClass;
import org.silbertb.proto.domainconverter.annotations.ProtoEnum;
import org.silbertb.proto.domainconverter.conversion_data.FieldType;
import org.silbertb.proto.domainconverter.custom.ProtoType;
import org.silbertb.proto.domainconverter.custom.TypeConverter;
import org.silbertb.proto.domainconverter.util.LangModelUtil;

public class ProtoTypeUtil {
    private final ProcessingEnvironment processingEnv;
    private final LangModelUtil langModelUtil;

    public ProtoTypeUtil(ProcessingEnvironment processingEnv, LangModelUtil langModelUtil) {
        this.processingEnv = processingEnv;
        this.langModelUtil = langModelUtil;
    }

    public String calculateDataStructureConcreteType(VariableElement field) {
        TypeMirror fieldType = field.asType();
        if (this.langModelUtil.isList(fieldType)) {
            if (this.langModelUtil.isConcreteType(field)) {
                return this.processingEnv.getTypeUtils().erasure(fieldType).toString();
            }
            return ArrayList.class.getName();
        }
        if (this.langModelUtil.isMap(fieldType)) {
            if (this.langModelUtil.isConcreteType(field)) {
                return this.processingEnv.getTypeUtils().erasure(fieldType).toString();
            }
            if (this.langModelUtil.isAssignedFrom(fieldType, SortedMap.class)) {
                return TreeMap.class.getName();
            }
            return HashMap.class.getName();
        }
        return null;
    }

    public FieldType calculateFieldType(TypeMirror fieldType) {
        return this.calculateFieldType(fieldType, Set.of());
    }

    public FieldType calculateFieldType(TypeMirror fieldType, Set<String> knownMessages) {
        if (fieldType.getKind().equals((Object)TypeKind.BOOLEAN)) {
            return FieldType.BOOLEAN;
        }
        if (this.langModelUtil.isSameType(fieldType, String.class)) {
            return FieldType.STRING;
        }
        if (this.langModelUtil.isByteArray(fieldType)) {
            return FieldType.BYTES;
        }
        if (knownMessages.contains(fieldType.toString())) {
            DeclaredType declaredType = (DeclaredType)fieldType;
            return declaredType.asElement().getKind().equals((Object)ElementKind.ENUM) ? FieldType.ENUM : FieldType.MESSAGE;
        }
        if (this.isProtoMessage(fieldType)) {
            return FieldType.MESSAGE;
        }
        if (this.isProtoEnum(fieldType)) {
            return FieldType.ENUM;
        }
        if (this.langModelUtil.isList(fieldType)) {
            TypeMirror typeArgument = this.langModelUtil.getGenericsTypes(fieldType).get(0);
            if (knownMessages.contains(typeArgument.toString()) || this.isProtoMessage(typeArgument) || this.isProtoEnum(typeArgument)) {
                return FieldType.MESSAGE_LIST;
            }
            return FieldType.PRIMITIVE_LIST;
        }
        if (this.langModelUtil.isMap(fieldType)) {
            TypeMirror typeArgument = this.langModelUtil.getGenericsTypes(fieldType).get(1);
            if (knownMessages.contains(typeArgument.toString()) || this.isProtoMessage(typeArgument) || this.isProtoEnum(typeArgument)) {
                return FieldType.MAP_TO_MESSAGE;
            }
            return FieldType.PRIMITIVE_MAP;
        }
        return FieldType.OTHER;
    }

    public boolean isProtoMessage(TypeMirror fieldType) {
        if (fieldType.getKind().equals((Object)TypeKind.DECLARED)) {
            return this.langModelUtil.getAnnotation(fieldType, ProtoClass.class) != null;
        }
        return false;
    }

    public boolean isProtoEnum(TypeMirror fieldType) {
        if (fieldType.getKind().equals((Object)TypeKind.DECLARED)) {
            return this.langModelUtil.getAnnotation(fieldType, ProtoEnum.class) != null;
        }
        return false;
    }

    public TypeMirror getElementType(TypeMirror domainType, FieldType fieldType) {
        switch (fieldType) {
            case MESSAGE_LIST: {
                if (!(domainType instanceof DeclaredType)) break;
                DeclaredType declaredType = (DeclaredType)domainType;
                return declaredType.getTypeArguments().get(0);
            }
            case MAP_TO_MESSAGE: {
                if (!(domainType instanceof DeclaredType)) break;
                DeclaredType declaredType = (DeclaredType)domainType;
                return declaredType.getTypeArguments().get(1);
            }
        }
        return null;
    }

    public ProtoType getProtoTypeFromConverter(TypeMirror converter) {
        TypeMirror typeConverter = this.langModelUtil.getInterfaceOf(converter, TypeConverter.class.getName());
        List<? extends TypeMirror> typeArguments = this.langModelUtil.getGenericsTypes(typeConverter);
        TypeMirror protoType = typeArguments.get(1);
        if (this.langModelUtil.isMap(protoType)) {
            return ProtoType.MAP;
        }
        if (this.langModelUtil.isList(protoType)) {
            return ProtoType.LIST;
        }
        if (this.langModelUtil.isMessage(protoType)) {
            return ProtoType.MESSAGE;
        }
        return ProtoType.OTHER;
    }
}

