/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.rxp90.jsymspell.api;

import java.util.Objects;

public final class SuggestItem
implements Comparable<SuggestItem> {
    private final String suggestion;
    private final int editDistance;
    private final double frequencyOfSuggestionInDict;

    public SuggestItem(String suggestion, int editDistance, double frequencyOfSuggestionInDict) {
        this.suggestion = suggestion;
        this.editDistance = editDistance;
        this.frequencyOfSuggestionInDict = frequencyOfSuggestionInDict;
    }

    @Override
    public int compareTo(SuggestItem suggestItem) {
        if (this.editDistance == suggestItem.editDistance) {
            return Double.compare(suggestItem.frequencyOfSuggestionInDict, this.frequencyOfSuggestionInDict);
        }
        return Integer.compare(this.editDistance, suggestItem.editDistance);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SuggestItem that = (SuggestItem)o;
        return this.editDistance == that.editDistance && Double.compare(that.frequencyOfSuggestionInDict, this.frequencyOfSuggestionInDict) == 0 && Objects.equals(this.suggestion, that.suggestion);
    }

    public int hashCode() {
        return Objects.hash(this.suggestion, this.editDistance, this.frequencyOfSuggestionInDict);
    }

    public String getSuggestion() {
        return this.suggestion;
    }

    public int getEditDistance() {
        return this.editDistance;
    }

    public double getFrequencyOfSuggestionInDict() {
        return this.frequencyOfSuggestionInDict;
    }

    public String toString() {
        return "SuggestItem{suggestion='" + this.suggestion + "', editDistance=" + this.editDistance + ", frequencyOfSuggestionInDict=" + this.frequencyOfSuggestionInDict + "}";
    }
}

