package co.legato.deeplink

import android.content.Context
import android.util.Log
import co.legato.deeplink.data.AppConfiguration
import co.legato.deeplink.data.Environment
import co.legato.deeplink.data.GenerateLinkData
import co.legato.deeplink.networks.APIGenerator
import co.legato.deeplink.networks.client.CentralizeClient
import co.legato.deeplink.tasks.TaskImpl
import co.legato.deeplink.tasks.interfaces.Task
import co.legato.deeplink.tools.JsonGenerator.serializeToMapString
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.launch
import kotlinx.coroutines.withContext

class CentralizeDeepLink constructor(
    context: Context,
    private val config: AppConfiguration,
    environment: Environment
) {
    private var client: CentralizeClient

    init {
        val api = APIGenerator(context, environment.apiUrl)
        client = api.createService(CentralizeClient::class.java)
    }

    fun generateDeepLink(request: GenerateLinkData): Task<String> {
        val taskImpl = TaskImpl<String>()
        CoroutineScope(Dispatchers.IO).launch {
            try {

                val response =
                    client.generateDeepLink(config.serializeToMapString(), request = request);
                withContext(Dispatchers.Main) {
                    taskImpl.result = response.data?.link
                }
            } catch (ex: Exception) {
                ex.printStackTrace()
                withContext(Dispatchers.Main) {
                    taskImpl.exception = ex
                }
            }
        }
        return taskImpl
    }

    fun extraShortLink(shortToken: String): Task<Map<String, Any>> {
        val taskImpl = TaskImpl<Map<String, Any>>()
        CoroutineScope(Dispatchers.IO).launch {
            try {
                val appConfig = config.serializeToMapString()
                val response = client.extraParams(appConfig, shortToken);
                withContext(Dispatchers.Main) {
                    Log.d("FUCK","response data ${response.data}");
                    taskImpl.result = response.data?.metaData
                }
            } catch (ex: Exception) {
                ex.printStackTrace()
                withContext(Dispatchers.Main) {
                    taskImpl.exception = ex
                }
            }
        }
        return taskImpl
    }
}