package co.legato.deeplink.networks

import android.content.Context
import co.legato.deeplink.BuildConfig
import com.google.gson.Gson
import com.google.gson.GsonBuilder
import okhttp3.Interceptor
import okhttp3.OkHttpClient
import okhttp3.logging.HttpLoggingInterceptor
import retrofit2.Retrofit
import retrofit2.converter.gson.GsonConverterFactory
import java.util.concurrent.TimeUnit

internal open class BaseAPIGenerator(context: Context, url: String) {
    private val logging: HttpLoggingInterceptor = HttpLoggingInterceptor()
    private val httpClientBuilder: OkHttpClient.Builder = OkHttpClient.Builder()
    val gson: Gson by lazy { configGson().create() }
    private val retrofitBuilder: Retrofit.Builder = Retrofit.Builder()
        .baseUrl(url)
        .addConverterFactory(GsonConverterFactory.create(gson))

    private var mRetrofit: Retrofit? = null

    open fun configGson(): GsonBuilder {
        return GsonBuilder()
    }

    open fun addRetrofitBuilder(): Retrofit.Builder {
        retrofitBuilder.client(addOkHttpBuilder().build())
        return retrofitBuilder
    }

    open fun addOkHttpBuilder(): OkHttpClient.Builder {
        logging.level = HttpLoggingInterceptor.Level.BODY
        httpClientBuilder.readTimeout(configTimeout().toLong(), TimeUnit.SECONDS)
        httpClientBuilder.connectTimeout(configTimeout().toLong(), TimeUnit.SECONDS)
        if (BuildConfig.DEBUG) httpClientBuilder.addNetworkInterceptor(logging)
        getInterceptor().map { httpClientBuilder.addInterceptor(it) }
        return httpClientBuilder
    }

    open fun getInterceptor(): List<Interceptor> {
        return emptyList()
    }

    fun <S> createService(serviceClass: Class<S>): S {
        if (mRetrofit == null) mRetrofit = addRetrofitBuilder().build()
        return mRetrofit!!.create(serviceClass)
    }

    open fun configTimeout() = 30
}