/*
 * Decompiled with CFR 0.152.
 */
package co.legato.deeplink.networks.interceptors;

import android.util.Log;
import co.legato.deeplink.exts.AnyExtKt;
import co.legato.deeplink.networks.interceptors.RequestException;
import co.legato.deeplink.networks.interceptors.UnauthorizedException;
import co.legato.deeplink.networks.responses.BaseResponse;
import com.google.gson.Gson;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u0004\u0018\u00010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lco/legato/deeplink/networks/interceptors/ExceptionInterceptor;", "Lokhttp3/Interceptor;", "gson", "Lcom/google/gson/Gson;", "(Lcom/google/gson/Gson;)V", "handleExceptionInternal", "", "error", "Lco/legato/deeplink/networks/responses/BaseResponse;", "", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "ErrorLog", "deeplink_release"})
@SourceDebugExtension(value={"SMAP\nExceptionInterceptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExceptionInterceptor.kt\nco/legato/deeplink/networks/interceptors/ExceptionInterceptor\n+ 2 AnyExt.kt\nco/legato/deeplink/exts/AnyExtKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,59:1\n9#2,2:60\n11#2,3:63\n1#3:62\n*S KotlinDebug\n*F\n+ 1 ExceptionInterceptor.kt\nco/legato/deeplink/networks/interceptors/ExceptionInterceptor\n*L\n20#1:60,2\n20#1:63,3\n*E\n"})
public final class ExceptionInterceptor
implements Interceptor {
    @NotNull
    private final Gson gson;

    public ExceptionInterceptor(@NotNull Gson gson2) {
        Intrinsics.checkNotNullParameter((Object)gson2, (String)"gson");
        this.gson = gson2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        Object message;
        BaseResponse error;
        BaseResponse baseResponse;
        Object body;
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Response response = chain.proceed(chain.request());
        Object object = response.body();
        if (object == null || (object = object.string()) == null) {
            object = "";
        }
        Object object2 = body = object;
        boolean showLog$iv = false;
        boolean $i$f$catching = false;
        try {
            void $this$catching$iv;
            void $this$intercept_u24lambda_u241 = $this$catching$iv;
            boolean bl = false;
            Object object3 = this.gson.fromJson((String)$this$intercept_u24lambda_u241, BaseResponse.class);
            BaseResponse $this$intercept_u24lambda_u241_u24lambda_u240 = (BaseResponse)object3;
            boolean bl2 = false;
            $this$intercept_u24lambda_u241_u24lambda_u240.setCode(response.code());
            baseResponse = (BaseResponse)object3;
        }
        catch (Throwable e$iv) {
            baseResponse = null;
        }
        BaseResponse baseResponse2 = baseResponse;
        BaseResponse baseResponse3 = baseResponse2;
        if (baseResponse2 == null) {
            baseResponse3 = new BaseResponse(response.code(), response.message(), null, 4, null);
        }
        if ((error = baseResponse3).getCode() != 200) {
            message = new ErrorLog(response.request().url().toString(), (String)body);
            Log.d((String)"Error", (String)(" Response: " + AnyExtKt.toJson(message)));
        }
        if ((message = this.handleExceptionInternal(error)) != null) {
            Throwable $this$intercept_u24lambda_u242 = message;
            boolean bl = false;
            throw $this$intercept_u24lambda_u242;
        }
        ResponseBody responseBody = response.body();
        MediaType contentType = responseBody != null ? responseBody.contentType() : null;
        return response.newBuilder().body(ResponseBody.Companion.create((String)body, contentType)).build();
    }

    private final Throwable handleExceptionInternal(BaseResponse<? extends Object> error) {
        return switch (error.getCode()) {
            case 200 -> null;
            case 401 -> {
                String v1 = error.getMessage();
                if (v1 == null) {
                    v1 = "";
                }
                yield new UnauthorizedException(v1);
            }
            default -> {
                int var2_2 = error.getCode();
                String v2 = error.getMessage();
                if (v2 == null) {
                    v2 = "";
                }
                String var3_3 = v2;
                yield new RequestException(var3_3, var2_2, "");
            }
        };
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lco/legato/deeplink/networks/interceptors/ExceptionInterceptor$ErrorLog;", "", "url", "", "message", "(Ljava/lang/String;Ljava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "getUrl", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "deeplink_release"})
    public static final class ErrorLog {
        @NotNull
        private final String url;
        @NotNull
        private final String message;

        public ErrorLog(@NotNull String url, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            this.url = url;
            this.message = message;
        }

        public /* synthetic */ ErrorLog(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = "";
            }
            if ((n & 2) != 0) {
                string2 = "";
            }
            this(string, string2);
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        @NotNull
        public final String component1() {
            return this.url;
        }

        @NotNull
        public final String component2() {
            return this.message;
        }

        @NotNull
        public final ErrorLog copy(@NotNull String url, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            return new ErrorLog(url, message);
        }

        public static /* synthetic */ ErrorLog copy$default(ErrorLog errorLog, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = errorLog.url;
            }
            if ((n & 2) != 0) {
                string2 = errorLog.message;
            }
            return errorLog.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "ErrorLog(url=" + this.url + ", message=" + this.message + ")";
        }

        public int hashCode() {
            int result = this.url.hashCode();
            result = result * 31 + this.message.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ErrorLog)) {
                return false;
            }
            ErrorLog errorLog = (ErrorLog)other;
            if (!Intrinsics.areEqual((Object)this.url, (Object)errorLog.url)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.message, (Object)errorLog.message);
        }

        public ErrorLog() {
            this(null, null, 3, null);
        }
    }
}

