package co.legato.deeplink.data

import androidx.annotation.Keep

@Keep
enum class Environment(internal val value: String, internal val apiUrl: String) {
    Prg("prg", "https://deeplinkdev-cms.legato.co/api/"),
    Uat("uat", "https://deeplinkdev-cms.legato.co/api/"),
    Dev("dev", "https://deeplinkdev-cms.legato.co/api/"),
    Prd("prd", "https://deeplinkdev-cms.legato.co/api/");

    companion object {
        fun find(value: String): Environment {
            return values().find { it.value == value } ?: Dev
        }
    }
}