package co.legato.deeplink.exts;

import co.legato.deeplink.tools.JsonGenerator


fun Any?.toJson(): String = JsonGenerator.convertJson(this ?: "{}")

inline fun <T, R> T.catching(showLog: Boolean = true, block: T.() -> R): R? {
    return try {
        block()
    } catch (e: Throwable) {
        if (showLog) e.printStackTrace()
        null
    }
}
