package co.legato.deeplink.tasks.interfaces

abstract class Task<TResult> {
    var completeListener: OnCompleteListener<TResult>? = null
    var failureListener: OnFailureListener? = null
    var successListener: OnSuccessListener<TResult>? = null

    fun addOnCompleteListener(var1: OnCompleteListener<TResult>): Task<TResult> {
        completeListener = var1
        return this
    }

    fun addOnFailureListener(var1: OnFailureListener): Task<TResult> {
        failureListener = var1
        return this
    }

    fun addOnSuccessListener(var1: OnSuccessListener<TResult>): Task<TResult> {
        successListener = var1
        return this
    }


    abstract val exception: Exception?

    abstract var result: TResult?

    abstract val isComplete: Boolean

    abstract val isSuccessful: Boolean
}