package co.legato.deeplink.networks.client

import co.legato.deeplink.data.GenerateLinkData
import co.legato.deeplink.data.GenerateLinkRequest
import co.legato.deeplink.networks.responses.BaseResponse
import co.legato.deeplink.networks.responses.DeepLinkResponse
import co.legato.deeplink.networks.responses.ExtraMetaDataResponse
import retrofit2.http.Body
import retrofit2.http.HeaderMap
import retrofit2.http.POST
import retrofit2.http.Query

internal interface CentralizeClient {

    @POST("v1/deeplink/extract")
    suspend fun extraParams(
        @HeaderMap appConfig: Map<String, String>,
        @Body metaData: Map<String, Boolean>? = null,
        @Query("shortUri") token: String,
    ): BaseResponse<ExtraMetaDataResponse>

    @POST("/api/v1/deeplink/generate")
    suspend fun generateDeepLink(
        @HeaderMap appConfig: Map<String, String>,
        @Body request: GenerateLinkRequest
    ): BaseResponse<DeepLinkResponse>
}