package co.legato.deeplink.tasks

import co.legato.deeplink.tasks.interfaces.Task

class TaskImpl<TResult> : Task<TResult>() {
    override var exception: Exception? = null
        set(value) {
            field = value
            isComplete = true
            if (value != null) {
                failureListener?.onFailure(value)
            } else {
                failureListener?.onFailure(IllegalArgumentException())
            }
        }
    override var result: TResult? = null
        set(value) {
            field = value
            isSuccessful = false
            isComplete = true
            if (value != null) {
                isSuccessful = true
                successListener?.onSuccess(value)
                completeListener?.onComplete(this)
            } else {
                failureListener?.onFailure(IllegalArgumentException("Task Result is null"))
            }
        }

    override var isComplete: Boolean = false
    override var isSuccessful: Boolean = false
}