package co.legato.deeplink.networks.responses

import androidx.annotation.Keep
import com.google.gson.annotations.SerializedName
import java.util.Date

@Keep
data class BaseResponse<out T : Any>(
    @SerializedName("code") var code: Int = 200,
    @SerializedName("message") val message: String?,
    @SerializedName("data") val data: T? = null
) {
    fun success(): Boolean = code == 200
            || code == 0
            || message?.lowercase() == "ok"
}

@Keep
data class BaseResultResponse(
    @SerializedName("code") var code: Int = 200,
    @SerializedName("message") val message: String?,
) {
    fun success(): Boolean = code == 200
            || code == 0
            || message?.lowercase() == "ok"
}