package co.legato.deeplink.data

import androidx.annotation.Keep
import co.legato.deeplink.tools.JsonGenerator.serializeToMap
import com.google.gson.annotations.SerializedName

@Keep
public data class GenerateLinkData(
    val type: String = "short",
    val metadata: Map<String, Any>,
    @SerializedName("page_url") val pageUrl: String,
    @SerializedName("is_force_create")val isForceCreate: Boolean = false,
    val socialMediaTag: SocialMediaTag? = null
) {
    constructor(metaData: Map<String, Any>, pageUrl: String) : this(
        "short",
        metaData,
        pageUrl,
        false,
        null
    )

    constructor(metaData: Map<String, Any>, pageUrl: String, socialMediaTag: SocialMediaTag) : this(
        "short",
        metaData,
        pageUrl,
        false,
        socialMediaTag
    )

    constructor(
        metaData: Map<String, Any>,
        pageUrl: String,
        socialMediaTag: SocialMediaTag,
        isForceCreate: Boolean
    ) : this("short", metaData, pageUrl, isForceCreate, socialMediaTag)

}

@Keep
internal data class GenerateLinkRequest(
    val type: String = "short",
    val metadata: Map<String, Any>,
    @SerializedName("page_url") val pageUrl: String,
    @SerializedName("is_force_create") val isForceCreate: Boolean = false
) {
    companion object {
        fun from(generateLinkData: GenerateLinkData): GenerateLinkRequest {
            val socialMap = generateLinkData.socialMediaTag?.serializeToMap()
            val metadata = generateLinkData.metadata.toMutableMap()
            socialMap?.let { metadata.putAll(it) }
            return GenerateLinkRequest(
                generateLinkData.type,
                metadata,
                generateLinkData.pageUrl,
                generateLinkData.isForceCreate
            )
        }
    }
}