package co.legato.deeplink.networks

import android.content.Context
import co.legato.deeplink.networks.interceptors.ExceptionInterceptor
import com.google.gson.GsonBuilder
import com.google.gson.Strictness
import okhttp3.ConnectionSpec
import okhttp3.Interceptor
import okhttp3.OkHttpClient
import java.lang.reflect.Modifier
import java.util.Date


internal class APIGenerator(context: Context, url: String) :
    BaseAPIGenerator(context, url) {

    override fun configGson(): GsonBuilder {
        return super.configGson()
            .setStrictness(Strictness.LENIENT)
            .setPrettyPrinting()
            .excludeFieldsWithModifiers(Modifier.TRANSIENT, Modifier.STATIC, Modifier.VOLATILE)
    }

    override fun addOkHttpBuilder(): OkHttpClient.Builder {
        val builder = super.addOkHttpBuilder()
        builder.retryOnConnectionFailure(false)
        val spec = listOf(ConnectionSpec.COMPATIBLE_TLS, ConnectionSpec.CLEARTEXT)
        builder.connectionSpecs(spec)
        return builder
    }

    override fun getInterceptor(): List<Interceptor> {
        val list = super.getInterceptor().toMutableList()
        list.add(ExceptionInterceptor(gson))
        return list
    }
}