/*
 * Decompiled with CFR 0.152.
 */
package io.glutenproject.execution;

import io.glutenproject.columnarbatch.ColumnarBatches;
import io.glutenproject.exec.Runtime;
import io.glutenproject.exec.Runtimes$;
import io.glutenproject.execution.RowToVeloxColumnarExec;
import io.glutenproject.memory.arrowalloc.ArrowBufferAllocators;
import io.glutenproject.memory.nmm.NativeMemoryManagers;
import io.glutenproject.utils.ArrowAbiUtil$;
import io.glutenproject.utils.Iterators$;
import io.glutenproject.vectorized.NativeRowToColumnarJniWrapper;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.arrow.c.ArrowSchema;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.utils.SparkArrowUtil$;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.util.TaskResources$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Some;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

public final class RowToVeloxColumnarExec$
implements scala.Serializable {
    public static RowToVeloxColumnarExec$ MODULE$;

    static {
        new RowToVeloxColumnarExec$();
    }

    public Iterator<ColumnarBatch> toColumnarBatchIterator(Iterator<InternalRow> it, StructType schema, SQLMetric numInputRows, SQLMetric numOutputBatches, SQLMetric convertTime, int columnBatchSize) {
        long l;
        if (it.isEmpty()) {
            return package$.MODULE$.Iterator().empty();
        }
        Schema arrowSchema = SparkArrowUtil$.MODULE$.toArrowSchema(schema, SQLConf$.MODULE$.get().sessionLocalTimeZone());
        NativeRowToColumnarJniWrapper jniWrapper = NativeRowToColumnarJniWrapper.create();
        BufferAllocator allocator = ArrowBufferAllocators.contextInstance();
        try (ArrowSchema cSchema = ArrowSchema.allocateNew((BufferAllocator)allocator);){
            ArrowAbiUtil$.MODULE$.exportSchema(allocator, arrowSchema, cSchema);
            l = jniWrapper.init(cSchema.memoryAddress(), NativeMemoryManagers.contextInstance((String)"RowToColumnar").getNativeInstanceHandle());
        }
        long r2cHandle = l;
        Iterator<ColumnarBatch> res = new Iterator<ColumnarBatch>(it, columnBatchSize, allocator, numInputRows, jniWrapper, r2cHandle, schema, numOutputBatches, convertTime){
            private boolean finished;
            private final Iterator it$1;
            private final int columnBatchSize$1;
            private final BufferAllocator allocator$1;
            private final SQLMetric numInputRows$2;
            private final NativeRowToColumnarJniWrapper jniWrapper$1;
            private final long r2cHandle$1;
            private final StructType schema$1;
            private final SQLMetric numOutputBatches$2;
            private final SQLMetric convertTime$2;

            public Iterator<ColumnarBatch> seq() {
                return Iterator.seq$((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.isEmpty$((Iterator)this);
            }

            public boolean isTraversableAgain() {
                return Iterator.isTraversableAgain$((Iterator)this);
            }

            public boolean hasDefiniteSize() {
                return Iterator.hasDefiniteSize$((Iterator)this);
            }

            public Iterator<ColumnarBatch> take(int n) {
                return Iterator.take$((Iterator)this, (int)n);
            }

            public Iterator<ColumnarBatch> drop(int n) {
                return Iterator.drop$((Iterator)this, (int)n);
            }

            public Iterator<ColumnarBatch> slice(int from, int until) {
                return Iterator.slice$((Iterator)this, (int)from, (int)until);
            }

            public Iterator<ColumnarBatch> sliceIterator(int from, int until) {
                return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<B> map(Function1<ColumnarBatch, B> f) {
                return Iterator.map$((Iterator)this, f);
            }

            public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                return Iterator.$plus$plus$((Iterator)this, that);
            }

            public <B> Iterator<B> flatMap(Function1<ColumnarBatch, GenTraversableOnce<B>> f) {
                return Iterator.flatMap$((Iterator)this, f);
            }

            public Iterator<ColumnarBatch> filter(Function1<ColumnarBatch, Object> p) {
                return Iterator.filter$((Iterator)this, p);
            }

            public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<ColumnarBatch, B, Object> p) {
                return Iterator.corresponds$((Iterator)this, that, p);
            }

            public Iterator<ColumnarBatch> withFilter(Function1<ColumnarBatch, Object> p) {
                return Iterator.withFilter$((Iterator)this, p);
            }

            public Iterator<ColumnarBatch> filterNot(Function1<ColumnarBatch, Object> p) {
                return Iterator.filterNot$((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<ColumnarBatch, B> pf) {
                return Iterator.collect$((Iterator)this, pf);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, ColumnarBatch, B> op) {
                return Iterator.scanLeft$((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<ColumnarBatch, B, B> op) {
                return Iterator.scanRight$((Iterator)this, z, op);
            }

            public Iterator<ColumnarBatch> takeWhile(Function1<ColumnarBatch, Object> p) {
                return Iterator.takeWhile$((Iterator)this, p);
            }

            public Tuple2<Iterator<ColumnarBatch>, Iterator<ColumnarBatch>> partition(Function1<ColumnarBatch, Object> p) {
                return Iterator.partition$((Iterator)this, p);
            }

            public Tuple2<Iterator<ColumnarBatch>, Iterator<ColumnarBatch>> span(Function1<ColumnarBatch, Object> p) {
                return Iterator.span$((Iterator)this, p);
            }

            public Iterator<ColumnarBatch> dropWhile(Function1<ColumnarBatch, Object> p) {
                return Iterator.dropWhile$((Iterator)this, p);
            }

            public <B> Iterator<Tuple2<ColumnarBatch, B>> zip(Iterator<B> that) {
                return Iterator.zip$((Iterator)this, that);
            }

            public <A1> Iterator<A1> padTo(int len, A1 elem) {
                return Iterator.padTo$((Iterator)this, (int)len, elem);
            }

            public Iterator<Tuple2<ColumnarBatch, Object>> zipWithIndex() {
                return Iterator.zipWithIndex$((Iterator)this);
            }

            public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
            }

            public <U> void foreach(Function1<ColumnarBatch, U> f) {
                Iterator.foreach$((Iterator)this, f);
            }

            public boolean forall(Function1<ColumnarBatch, Object> p) {
                return Iterator.forall$((Iterator)this, p);
            }

            public boolean exists(Function1<ColumnarBatch, Object> p) {
                return Iterator.exists$((Iterator)this, p);
            }

            public boolean contains(Object elem) {
                return Iterator.contains$((Iterator)this, (Object)elem);
            }

            public Option<ColumnarBatch> find(Function1<ColumnarBatch, Object> p) {
                return Iterator.find$((Iterator)this, p);
            }

            public int indexWhere(Function1<ColumnarBatch, Object> p) {
                return Iterator.indexWhere$((Iterator)this, p);
            }

            public int indexWhere(Function1<ColumnarBatch, Object> p, int from) {
                return Iterator.indexWhere$((Iterator)this, p, (int)from);
            }

            public <B> int indexOf(B elem) {
                return Iterator.indexOf$((Iterator)this, elem);
            }

            public <B> int indexOf(B elem, int from) {
                return Iterator.indexOf$((Iterator)this, elem, (int)from);
            }

            public BufferedIterator<ColumnarBatch> buffered() {
                return Iterator.buffered$((Iterator)this);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.grouped$((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.sliding$((Iterator)this, (int)size, (int)step);
            }

            public <B> int sliding$default$2() {
                return Iterator.sliding$default$2$((Iterator)this);
            }

            public int length() {
                return Iterator.length$((Iterator)this);
            }

            public Tuple2<Iterator<ColumnarBatch>, Iterator<ColumnarBatch>> duplicate() {
                return Iterator.duplicate$((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <B> void copyToArray(Object xs, int start, int len) {
                Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
            }

            public boolean sameElements(Iterator<?> that) {
                return Iterator.sameElements$((Iterator)this, that);
            }

            public Traversable<ColumnarBatch> toTraversable() {
                return Iterator.toTraversable$((Iterator)this);
            }

            public Iterator<ColumnarBatch> toIterator() {
                return Iterator.toIterator$((Iterator)this);
            }

            public Stream<ColumnarBatch> toStream() {
                return Iterator.toStream$((Iterator)this);
            }

            public String toString() {
                return Iterator.toString$((Iterator)this);
            }

            public List<ColumnarBatch> reversed() {
                return TraversableOnce.reversed$((TraversableOnce)this);
            }

            public int size() {
                return TraversableOnce.size$((TraversableOnce)this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.nonEmpty$((TraversableOnce)this);
            }

            public int count(Function1<ColumnarBatch, Object> p) {
                return TraversableOnce.count$((TraversableOnce)this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<ColumnarBatch, B> pf) {
                return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, ColumnarBatch, B> op) {
                return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<ColumnarBatch, B, B> op) {
                return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, ColumnarBatch, B> op) {
                return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
            }

            public <B> B foldRight(B z, Function2<ColumnarBatch, B, B> op) {
                return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
            }

            public <B> B reduceLeft(Function2<B, ColumnarBatch, B> op) {
                return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
            }

            public <B> B reduceRight(Function2<ColumnarBatch, B, B> op) {
                return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, ColumnarBatch, B> op) {
                return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<ColumnarBatch, B, B> op) {
                return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.reduceOption$((TraversableOnce)this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, ColumnarBatch, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.sum$((TraversableOnce)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.product$((TraversableOnce)this, num);
            }

            public Object min(Ordering cmp) {
                return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
            }

            public Object max(Ordering cmp) {
                return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
            }

            public <B> void copyToArray(Object xs, int start) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
            }

            public List<ColumnarBatch> toList() {
                return TraversableOnce.toList$((TraversableOnce)this);
            }

            public Iterable<ColumnarBatch> toIterable() {
                return TraversableOnce.toIterable$((TraversableOnce)this);
            }

            public Seq<ColumnarBatch> toSeq() {
                return TraversableOnce.toSeq$((TraversableOnce)this);
            }

            public IndexedSeq<ColumnarBatch> toIndexedSeq() {
                return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.toBuffer$((TraversableOnce)this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.toSet$((TraversableOnce)this);
            }

            public Vector<ColumnarBatch> toVector() {
                return TraversableOnce.toVector$((TraversableOnce)this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, ColumnarBatch, Col> cbf) {
                return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
            }

            public <T, U> Map<T, U> toMap(Predef.$less$colon$less<ColumnarBatch, Tuple2<T, U>> ev) {
                return TraversableOnce.toMap$((TraversableOnce)this, ev);
            }

            public String mkString(String start, String sep, String end) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
            }

            public String mkString(String sep) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
            }

            public String mkString() {
                return TraversableOnce.mkString$((TraversableOnce)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
            }

            public int sizeHintIfCheap() {
                return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
            }

            private boolean finished() {
                return this.finished;
            }

            private void finished_$eq(boolean x$1) {
                this.finished = x$1;
            }

            public boolean hasNext() {
                return this.finished() ? false : this.it$1.hasNext();
            }

            private ColumnarBatch nativeConvert(UnsafeRow row) {
                ColumnarBatch columnarBatch;
                ObjectRef arrowBuf = ObjectRef.create(null);
                TaskResources$.MODULE$.addRecycler("RowToColumnar_arrowBuf", 100, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    block0: {
                        if ((ArrowBuf)arrowBuf$1.elem == null || ((ArrowBuf)arrowBuf$1.elem).refCnt() == 0) break block0;
                        ((ArrowBuf)arrowBuf$1.elem).close();
                    }
                });
                ListBuffer rowLength = new ListBuffer();
                int rowCount = 0;
                int offset = 0;
                int sizeInBytes = row.getSizeInBytes();
                double estimatedBufSize = Math.max(Math.min((double)sizeInBytes * (double)this.columnBatchSize$1 * 1.2, (double)(31760L * (long)this.columnBatchSize$1)), (double)sizeInBytes * (double)10);
                arrowBuf.elem = this.allocator$1.buffer((long)estimatedBufSize);
                Platform.copyMemory((Object)row.getBaseObject(), (long)row.getBaseOffset(), null, (long)(((ArrowBuf)arrowBuf.elem).memoryAddress() + (long)offset), (long)sizeInBytes);
                offset += sizeInBytes;
                rowLength.$plus$eq((Object)BoxesRunTime.boxToLong((long)sizeInBytes));
                ++rowCount;
                while (rowCount < this.columnBatchSize$1 && !this.finished()) {
                    boolean iterHasNext = this.it$1.hasNext();
                    if (!iterHasNext) {
                        this.finished_$eq(true);
                        continue;
                    }
                    InternalRow row2 = (InternalRow)this.it$1.next();
                    UnsafeRow unsafeRow = this.convertToUnsafeRow(row2);
                    int sizeInBytes2 = unsafeRow.getSizeInBytes();
                    if ((long)(offset + sizeInBytes2) > ((ArrowBuf)arrowBuf.elem).capacity()) {
                        ArrowBuf tmpBuf = this.allocator$1.buffer((long)((offset + sizeInBytes2) * 2));
                        tmpBuf.setBytes(0L, (ArrowBuf)arrowBuf.elem, 0L, (long)offset);
                        ((ArrowBuf)arrowBuf.elem).close();
                        arrowBuf.elem = tmpBuf;
                    }
                    Platform.copyMemory((Object)unsafeRow.getBaseObject(), (long)unsafeRow.getBaseOffset(), null, (long)(((ArrowBuf)arrowBuf.elem).memoryAddress() + (long)offset), (long)sizeInBytes2);
                    offset += sizeInBytes2;
                    rowLength.$plus$eq((Object)BoxesRunTime.boxToLong((long)sizeInBytes2));
                    ++rowCount;
                }
                this.numInputRows$2.$plus$eq((long)rowCount);
                try {
                    long handle = this.jniWrapper$1.nativeConvertRowToColumnar(this.r2cHandle$1, (long[])rowLength.toArray(ClassTag$.MODULE$.Long()), ((ArrowBuf)arrowBuf.elem).memoryAddress());
                    columnarBatch = ColumnarBatches.create((Runtime)Runtimes$.MODULE$.contextInstance(), (long)handle);
                }
                finally {
                    ((ArrowBuf)arrowBuf.elem).close();
                    arrowBuf.elem = null;
                }
                return columnarBatch;
            }

            private UnsafeRow convertToUnsafeRow(InternalRow row) {
                UnsafeRow unsafeRow;
                InternalRow internalRow = row;
                if (internalRow instanceof UnsafeRow) {
                    UnsafeRow unsafeRow2;
                    unsafeRow = unsafeRow2 = (UnsafeRow)internalRow;
                } else {
                    UnsafeProjection$ factory = UnsafeProjection$.MODULE$;
                    UnsafeProjection converter = factory.create(this.schema$1);
                    unsafeRow = converter.apply(row);
                }
                return unsafeRow;
            }

            public ColumnarBatch next() {
                InternalRow firstRow = (InternalRow)this.it$1.next();
                long start = System.currentTimeMillis();
                UnsafeRow unsafeRow = this.convertToUnsafeRow(firstRow);
                ColumnarBatch cb = this.nativeConvert(unsafeRow);
                this.numOutputBatches$2.$plus$eq(1L);
                this.convertTime$2.$plus$eq(System.currentTimeMillis() - start);
                return cb;
            }
            {
                this.it$1 = it$1;
                this.columnBatchSize$1 = columnBatchSize$1;
                this.allocator$1 = allocator$1;
                this.numInputRows$2 = numInputRows$2;
                this.jniWrapper$1 = jniWrapper$1;
                this.r2cHandle$1 = r2cHandle$1;
                this.schema$1 = schema$1;
                this.numOutputBatches$2 = numOutputBatches$2;
                this.convertTime$2 = convertTime$2;
                GenTraversableOnce.$init$((GenTraversableOnce)this);
                TraversableOnce.$init$((TraversableOnce)this);
                Iterator.$init$((Iterator)this);
                this.finished = false;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$nativeConvert$1(scala.runtime.ObjectRef )}, serializedLambda);
            }
        };
        return Iterators$.MODULE$.wrap((Iterator)res).recycleIterator((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> jniWrapper.close(r2cHandle)).recyclePayload((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.close();
            return BoxedUnit.UNIT;
        }).create();
    }

    public RowToVeloxColumnarExec apply(SparkPlan child) {
        return new RowToVeloxColumnarExec(child);
    }

    public Option<SparkPlan> unapply(RowToVeloxColumnarExec x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)x$0.child());
    }

    private Object readResolve() {
        return MODULE$;
    }

    private RowToVeloxColumnarExec$() {
        MODULE$ = this;
    }
}

