/*
 * Decompiled with CFR 0.152.
 */
package io.glutenproject.fs;

import com.google.common.jimfs.Configuration;
import com.google.common.jimfs.Jimfs;
import io.glutenproject.fs.JniFilesystem;
import io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicInteger;

public class OnHeapFileSystem
implements JniFilesystem {
    public static final JniFilesystem INSTANCE = new OnHeapFileSystem();
    private final FileSystem fs;

    private OnHeapFileSystem() {
        long maxSize = Runtime.getRuntime().maxMemory();
        this.fs = Jimfs.newFileSystem((Configuration)Configuration.unix().toBuilder().setMaxSize(maxSize).setMaxCacheSize(0L).build());
    }

    @Override
    public boolean isCapableForNewFile0(long size) {
        long freeMemory = Runtime.getRuntime().freeMemory();
        return (double)freeMemory * 0.75 > (double)size;
    }

    private void ensureExist(String path) {
        if (!this.exists(path)) {
            throw new UnsupportedOperationException("OnHeapFileSystem: File doesn't exist: " + path);
        }
    }

    private void ensureNotExist(String path) {
        if (this.exists(path)) {
            throw new UnsupportedOperationException("OnHeapFileSystem: File already exists " + path);
        }
    }

    @Override
    public ReadFile openFileForRead(String path) {
        this.ensureExist(path);
        return new ReadFile(this.fs.getPath(path, new String[0]));
    }

    @Override
    public WriteFile openFileForWrite(String path) {
        this.ensureNotExist(path);
        return new WriteFile(this.fs.getPath(path, new String[0]));
    }

    @Override
    public void remove(String path) {
        this.ensureExist(path);
        try {
            Files.delete(this.fs.getPath(path, new String[0]));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void rename(String oldPath, String newPath, boolean overwrite) {
        this.ensureExist(oldPath);
        StandardCopyOption option = overwrite ? StandardCopyOption.REPLACE_EXISTING : StandardCopyOption.ATOMIC_MOVE;
        try {
            Files.move(this.fs.getPath(oldPath, new String[0]), this.fs.getPath(newPath, new String[0]), option);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean exists(String path) {
        Path p = this.fs.getPath(path, new String[0]);
        return Files.exists(p, new LinkOption[0]);
    }

    @Override
    public String[] list(String path) {
        this.ensureExist(path);
        try {
            return (String[])Files.list(this.fs.getPath(path, new String[0])).map(Path::toString).toArray(String[]::new);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void mkdir(String path) {
        this.ensureNotExist(path);
        try {
            Files.createDirectories(this.fs.getPath(path, new String[0]), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void rmdir(String path) {
        this.ensureExist(path);
        try {
            Files.walk(this.fs.getPath(path, new String[0]), new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(p -> {
                try {
                    Files.delete(p);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static class WriteFile
    implements JniFilesystem.WriteFile {
        private final Path path;
        private final OutputStream out;
        private final AtomicInteger writtenBytes = new AtomicInteger(0);
        private final WritableByteChannel channel;

        private WriteFile(Path path) {
            this.path = path;
            try {
                this.out = Files.newOutputStream(this.path, StandardOpenOption.CREATE_NEW);
                this.channel = Channels.newChannel(this.out);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void append(long length, long buf) {
            try {
                ByteBuffer in = PlatformDependent.directBuffer((long)buf, (int)((int)length));
                this.channel.write(in);
                this.writtenBytes.getAndAdd((int)length);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void flush() {
            try {
                this.out.flush();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void close() {
            try {
                this.channel.close();
                this.out.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public long size() {
            return this.writtenBytes.get();
        }
    }

    private static class ReadFile
    implements JniFilesystem.ReadFile {
        private final Path path;
        private final InputStream in;
        private final AtomicInteger cursor = new AtomicInteger(0);
        private final ReadableByteChannel channel;
        private final long size;

        private ReadFile(Path path) {
            this.path = path;
            try {
                this.in = Files.newInputStream(this.path, StandardOpenOption.READ);
                this.size = Files.size(this.path);
                this.channel = Channels.newChannel(this.in);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void pread(long offset, long length, long buf) {
            try {
                long toSkip;
                long skippedBytes;
                if (offset < (long)this.cursor.get()) {
                    throw new IllegalStateException("ReadFile: Offset to read is in front to the cursor position");
                }
                ByteBuffer out = PlatformDependent.directBuffer((long)buf, (int)((int)length));
                if (offset > (long)this.cursor.get() && (skippedBytes = this.in.skip(toSkip = offset - (long)this.cursor.get())) != toSkip) {
                    throw new IllegalStateException(String.format("ReadFile: Skipped size mismatch with expected size to skip: %d != %d", skippedBytes, toSkip));
                }
                this.channel.read(out);
                this.cursor.set((int)(offset + length));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean shouldCoalesce() {
            throw new UnsupportedOperationException("Not implemented");
        }

        @Override
        public long size() {
            return this.size;
        }

        @Override
        public long memoryUsage() {
            throw new UnsupportedOperationException("Not implemented");
        }

        @Override
        public long getNaturalReadSize() {
            throw new UnsupportedOperationException("Not implemented");
        }

        @Override
        public void close() {
            try {
                this.channel.close();
                this.in.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

