/*
 * Decompiled with CFR 0.152.
 */
package io.glutenproject.utils;

import io.glutenproject.datasource.DatasourceJniWrapper;
import io.glutenproject.memory.arrowalloc.ArrowBufferAllocators;
import io.glutenproject.memory.nmm.NativeMemoryManagers;
import io.glutenproject.utils.ArrowAbiUtil$;
import java.util.HashMap;
import org.apache.arrow.c.ArrowSchema;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.hadoop.fs.FileStatus;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.utils.SparkSchemaUtil$;
import scala.Option;
import scala.Option$;
import scala.collection.Seq;

public final class DatasourceUtil$ {
    public static DatasourceUtil$ MODULE$;

    static {
        new DatasourceUtil$();
    }

    public Option<StructType> readSchema(Seq<FileStatus> files) {
        if (files.isEmpty()) {
            throw new IllegalArgumentException("No input file specified");
        }
        return this.readSchema((FileStatus)files.toList().head());
    }

    public Option<StructType> readSchema(FileStatus file) {
        Option option;
        BufferAllocator allocator = ArrowBufferAllocators.contextInstance();
        DatasourceJniWrapper datasourceJniWrapper = DatasourceJniWrapper.create();
        long dsHandle = datasourceJniWrapper.nativeInitDatasource(file.getPath().toString(), -1L, NativeMemoryManagers.contextInstance((String)"VeloxWriter").getNativeInstanceHandle(), new HashMap());
        ArrowSchema cSchema = ArrowSchema.allocateNew((BufferAllocator)allocator);
        datasourceJniWrapper.inspectSchema(dsHandle, cSchema.memoryAddress());
        try {
            option = Option$.MODULE$.apply((Object)SparkSchemaUtil$.MODULE$.fromArrowSchema(ArrowAbiUtil$.MODULE$.importToSchema(allocator, cSchema)));
        }
        finally {
            cSchema.close();
            datasourceJniWrapper.close(dsHandle);
        }
        return option;
    }

    private DatasourceUtil$() {
        MODULE$ = this;
    }
}

