/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.velox;

import io.glutenproject.columnarbatch.ColumnarBatches;
import io.glutenproject.exec.Runtime;
import io.glutenproject.exec.Runtimes;
import java.util.Iterator;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.datasources.BlockStripe;
import org.apache.spark.sql.execution.datasources.BlockStripes;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.jetbrains.annotations.NotNull;

public class VeloxBlockStripes
extends BlockStripes {
    private int index = 0;

    public VeloxBlockStripes(BlockStripes bs) {
        super(bs.originBlockAddress, bs.blockAddresses, bs.headingRowIndice, bs.originBlockNumColumns, bs.rowBytes);
    }

    @NotNull
    public Iterator<BlockStripe> iterator() {
        return new Iterator<BlockStripe>(){

            @Override
            public boolean hasNext() {
                return VeloxBlockStripes.this.index < 1;
            }

            @Override
            public BlockStripe next() {
                VeloxBlockStripes.this.index = VeloxBlockStripes.this.index + 1;
                return new BlockStripe(){

                    public ColumnarBatch getColumnarBatch() {
                        return ColumnarBatches.create((Runtime)Runtimes.contextInstance(), (long)VeloxBlockStripes.this.blockAddresses[0]);
                    }

                    public InternalRow getHeadingRow() {
                        UnsafeRow row = new UnsafeRow(VeloxBlockStripes.this.originBlockNumColumns);
                        row.pointTo(VeloxBlockStripes.this.rowBytes, VeloxBlockStripes.this.rowBytes.length);
                        return row;
                    }
                };
            }
        };
    }

    public void release() {
    }
}

