/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.expression;

import io.glutenproject.backendsapi.velox.BackendSettings$;
import io.glutenproject.exception.GlutenException;
import io.glutenproject.substrait.ExpressionType;
import io.glutenproject.substrait.TypeConverter$;
import io.glutenproject.udf.UdfJniWrapper;
import io.glutenproject.vectorized.JniWorkspace;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkFiles$;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.FunctionIdentifier;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionInfo;
import org.apache.spark.sql.expression.UDFExpression;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class UDFResolver$
implements Logging {
    public static UDFResolver$ MODULE$;
    private boolean isDriver;
    private String localLibraryPaths;
    private final scala.collection.mutable.Map<String, ExpressionType> UDFMap;
    private final String LIB_EXTENSION;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    static {
        new UDFResolver$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String localLibraryPaths() {
        return this.localLibraryPaths;
    }

    public void localLibraryPaths_$eq(String x$1) {
        this.localLibraryPaths = x$1;
    }

    private scala.collection.mutable.Map<String, ExpressionType> UDFMap() {
        return this.UDFMap;
    }

    private String LIB_EXTENSION() {
        return this.LIB_EXTENSION;
    }

    private boolean isDriver$lzycompute() {
        UDFResolver$ uDFResolver$ = this;
        synchronized (uDFResolver$) {
            if (!this.bitmap$0) {
                this.isDriver = "driver".equals(SparkEnv$.MODULE$.get().executorId());
                this.bitmap$0 = true;
            }
        }
        return this.isDriver;
    }

    private boolean isDriver() {
        return !this.bitmap$0 ? this.isDriver$lzycompute() : this.isDriver;
    }

    public void registerUDF(String name, byte[] bytes) {
        this.registerUDF(name, TypeConverter$.MODULE$.from(bytes));
    }

    public void registerUDF(String name, ExpressionType t) {
        this.UDFMap().update((Object)name, (Object)t);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Registered UDF: ").append(name).append(" -> ").append(t).toString());
    }

    public Tuple2<String, String> parseName(String name) {
        int index = name.lastIndexOf("#");
        return index == -1 ? new Tuple2((Object)name, (Object)((Object)Paths.get(name, new String[0]).getFileName()).toString()) : new Tuple2((Object)name.substring(0, index), (Object)name.substring(index + 1));
    }

    public Seq<String> getFilesWithExtension(Path directory, String extension) {
        return ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(Files.walk(directory, new FileVisitOption[0]).iterator()).asScala()).filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)UDFResolver$.$anonfun$getFilesWithExtension$1(extension, p))).map((Function1 & Serializable & scala.Serializable)p -> ((Object)p).toString()).toSeq();
    }

    public void resolveUdfConf(Map<String, String> conf) {
        if (this.isDriver()) {
            if (this.localLibraryPaths() != null) {
                conf.put(BackendSettings$.MODULE$.GLUTEN_VELOX_UDF_LIB_PATHS(), this.localLibraryPaths());
            }
        } else {
            SparkConf sparkConf = SparkEnv$.MODULE$.get().conf();
            Option option = Option$.MODULE$.apply((Object)conf.get(BackendSettings$.MODULE$.GLUTEN_VELOX_UDF_LIB_PATHS()));
            if (option instanceof Some) {
                Some some = (Some)option;
                String libs = (String)some.value();
                conf.put(BackendSettings$.MODULE$.GLUTEN_VELOX_UDF_LIB_PATHS(), this.getAllLibraries(libs, sparkConf, true));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option);
            }
        }
    }

    public File unpack(File source, File destDir) {
        String sourceName = source.getName();
        File dest = new File(destDir, sourceName);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Unpacking an archive ").append(sourceName).append(" from ").append(source.getAbsolutePath()).append(" to ").append(dest.getAbsolutePath()).toString());
        try {
            Utils$.MODULE$.deleteRecursively(dest);
            Utils$.MODULE$.unpack(source, dest);
        }
        catch (Exception e) {
            throw new GlutenException(new StringBuilder(49).append("Unpack ").append(source.toString()).append(" failed. Please check if it is an archive.").toString(), (Throwable)e);
        }
        return dest;
    }

    public String getAllLibraries(String files, SparkConf sparkConf, boolean canAccessSparkFiles) {
        Configuration hadoopConf = SparkHadoopUtil$.MODULE$.newConfiguration(sparkConf);
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files.split(","))).map((Function1 & Serializable & scala.Serializable)f -> {
            File file;
            File file2 = new File((String)f);
            if (!file2.isAbsolute()) {
                if (!canAccessSparkFiles) {
                    throw new IllegalArgumentException(new StringBuilder(65).append("On yarn-client mode, driver only accepts absolute paths, but got ").append((String)f).toString());
                }
                file = new File(SparkFiles$.MODULE$.get(f));
            } else {
                URI uri = Utils$.MODULE$.resolveURI(f);
                String name = file2.getName();
                File jniWorkspace = new File(JniWorkspace.getDefault().getWorkDir());
                if (!file2.isDirectory() && !f.endsWith(MODULE$.LIB_EXTENSION())) {
                    File source = Utils$.MODULE$.doFetchFile(uri.toString(), Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()), name, sparkConf, hadoopConf);
                    file = MODULE$.unpack(source, jniWorkspace);
                } else {
                    file = Utils$.MODULE$.doFetchFile(uri.toString(), jniWorkspace, name, sparkConf, hadoopConf);
                }
            }
            return file;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class))))).flatMap((Function1 & Serializable & scala.Serializable)f -> f.isDirectory() ? MODULE$.getFilesWithExtension(f.toPath(), MODULE$.LIB_EXTENSION()) : (Seq)new .colon.colon((Object)f.toString(), (List)Nil$.MODULE$), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(",");
    }

    public Seq<Tuple3<FunctionIdentifier, ExpressionInfo, Function1<Seq<Expression>, Expression>>> loadAndGetFunctionDescriptions() {
        Seq seq;
        SparkContext sparkContext = (SparkContext)SparkContext$.MODULE$.getActive().get();
        SparkConf sparkConf = sparkContext.conf();
        Option udfLibPaths = sparkConf.getOption(BackendSettings$.MODULE$.GLUTEN_VELOX_DRIVER_UDF_LIB_PATHS()).orElse((Function0 & Serializable & scala.Serializable)() -> sparkConf.getOption(BackendSettings$.MODULE$.GLUTEN_VELOX_UDF_LIB_PATHS()));
        Option option = udfLibPaths;
        if (None$.MODULE$.equals(option)) {
            seq = (Seq)Nil$.MODULE$;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            String paths = (String)some.value();
            Option master = sparkConf.getOption("spark.master");
            boolean isYarnClient = master.isDefined() && ((String)master.get()).equals("yarn") && Utils$.MODULE$.isClientMode(sparkConf);
            this.localLibraryPaths_$eq(this.getAllLibraries(paths, sparkConf, !isYarnClient));
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Loading UDF libraries from paths: ").append(MODULE$.localLibraryPaths()).toString());
            new UdfJniWrapper().nativeLoadUdfLibraries(this.localLibraryPaths());
            seq = ((TraversableOnce)this.UDFMap().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String name = (String)tuple2._1();
                ExpressionType t = (ExpressionType)tuple2._2();
                Tuple3 tuple3 = new Tuple3((Object)new FunctionIdentifier(name), (Object)new ExpressionInfo(UDFExpression.class.getName(), name), (Function1 & Serializable & scala.Serializable)e -> new UDFExpression(name, t.dataType(), t.nullable(), (Seq<Expression>)e));
                return tuple3;
            }, Iterable$.MODULE$.canBuildFrom())).toSeq();
        } else {
            throw new MatchError((Object)option);
        }
        return seq;
    }

    public static final /* synthetic */ boolean $anonfun$getFilesWithExtension$1(String extension$1, Path p) {
        return Files.isRegularFile(p, new LinkOption[0]) && ((Object)p).toString().endsWith(extension$1);
    }

    private UDFResolver$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.UDFMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.LIB_EXTENSION = ".so";
    }
}

