/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.aws.lambda.events;

import io.goodforgod.aws.lambda.events.BodyEvent;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;

public class Base64BodyEvent<T extends Base64BodyEvent<T>>
extends BodyEvent<T> {
    private static final Base64.Decoder DEFAULT_DECODER = Base64.getMimeDecoder();
    private boolean isBase64Encoded = false;

    public String getBodyRaw() {
        return super.getBody();
    }

    public boolean isBase64Encoded() {
        return this.isBase64Encoded;
    }

    @Override
    public String getBody() {
        return this.isBase64Encoded() ? this.decode(this.getBodyRaw()) : this.getBodyRaw();
    }

    public T setBase64Encoded(boolean base64Encoded) {
        this.isBase64Encoded = base64Encoded;
        return (T)this;
    }

    protected String decode(String stringAsBase64) {
        return new String(DEFAULT_DECODER.decode(stringAsBase64), StandardCharsets.UTF_8);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Base64BodyEvent that = (Base64BodyEvent)o;
        return this.isBase64Encoded == that.isBase64Encoded;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.isBase64Encoded);
    }

    @Override
    public String toString() {
        return "[isBase64Encoded=" + this.isBase64Encoded + "]";
    }
}

