/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.aws.lambda.events.dynamodb;

import io.goodforgod.aws.lambda.events.dynamodb.DynamoDBAttributeValue;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DynamoDBStreamRecord
implements Serializable {
    private long approximateCreationDateTime;
    private Map<String, DynamoDBAttributeValue> keys;
    private Map<String, DynamoDBAttributeValue> newImage;
    private Map<String, DynamoDBAttributeValue> oldImage;
    private String sequenceNumber;
    private Long sizeBytes;
    private StreamViewType streamViewType;

    public DynamoDBStreamRecord addKeysEntry(String key, DynamoDBAttributeValue value) {
        if (null == this.keys) {
            this.keys = new HashMap<String, DynamoDBAttributeValue>();
        }
        if (this.keys.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key + ") are provided.");
        }
        this.keys.put(key, value);
        return this;
    }

    public DynamoDBStreamRecord clearKeysEntries() {
        this.keys = null;
        return this;
    }

    public DynamoDBStreamRecord addNewImageEntry(String key, DynamoDBAttributeValue value) {
        if (null == this.newImage) {
            this.newImage = new HashMap<String, DynamoDBAttributeValue>();
        }
        if (this.newImage.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key + ") are provided.");
        }
        this.newImage.put(key, value);
        return this;
    }

    public DynamoDBStreamRecord clearNewImageEntries() {
        this.newImage = null;
        return this;
    }

    public DynamoDBStreamRecord addOldImageEntry(String key, DynamoDBAttributeValue value) {
        if (null == this.oldImage) {
            this.oldImage = new HashMap<String, DynamoDBAttributeValue>();
        }
        if (this.oldImage.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key + ") are provided.");
        }
        this.oldImage.put(key, value);
        return this;
    }

    public DynamoDBStreamRecord clearOldImageEntries() {
        this.oldImage = null;
        return this;
    }

    @NotNull
    public Map<String, DynamoDBAttributeValue> getKeys() {
        return this.keys == null ? Collections.emptyMap() : this.keys;
    }

    @NotNull
    public Map<String, DynamoDBAttributeValue> getNewImage() {
        return this.newImage == null ? Collections.emptyMap() : this.newImage;
    }

    @NotNull
    public Map<String, DynamoDBAttributeValue> getOldImage() {
        return this.oldImage == null ? Collections.emptyMap() : this.oldImage;
    }

    public long getApproximateCreationDateTime() {
        return this.approximateCreationDateTime;
    }

    public String getSequenceNumber() {
        return this.sequenceNumber;
    }

    public Long getSizeBytes() {
        return this.sizeBytes;
    }

    public StreamViewType getStreamViewType() {
        return this.streamViewType;
    }

    public DynamoDBStreamRecord setApproximateCreationDateTime(long approximateCreationDateTime) {
        this.approximateCreationDateTime = approximateCreationDateTime;
        return this;
    }

    public DynamoDBStreamRecord setKeys(Map<String, DynamoDBAttributeValue> keys) {
        this.keys = keys;
        return this;
    }

    public DynamoDBStreamRecord setNewImage(Map<String, DynamoDBAttributeValue> newImage) {
        this.newImage = newImage;
        return this;
    }

    public DynamoDBStreamRecord setOldImage(Map<String, DynamoDBAttributeValue> oldImage) {
        this.oldImage = oldImage;
        return this;
    }

    public DynamoDBStreamRecord setSequenceNumber(String sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
        return this;
    }

    public DynamoDBStreamRecord setSizeBytes(Long sizeBytes) {
        this.sizeBytes = sizeBytes;
        return this;
    }

    public DynamoDBStreamRecord setStreamViewType(StreamViewType streamViewType) {
        this.streamViewType = streamViewType;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DynamoDBStreamRecord)) {
            return false;
        }
        DynamoDBStreamRecord other = (DynamoDBStreamRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getApproximateCreationDateTime() != other.getApproximateCreationDateTime()) {
            return false;
        }
        Long this$sizeBytes = this.getSizeBytes();
        Long other$sizeBytes = other.getSizeBytes();
        if (this$sizeBytes == null ? other$sizeBytes != null : !((Object)this$sizeBytes).equals(other$sizeBytes)) {
            return false;
        }
        Map<String, DynamoDBAttributeValue> this$keys = this.getKeys();
        Map<String, DynamoDBAttributeValue> other$keys = other.getKeys();
        if (this$keys == null ? other$keys != null : !((Object)this$keys).equals(other$keys)) {
            return false;
        }
        Map<String, DynamoDBAttributeValue> this$newImage = this.getNewImage();
        Map<String, DynamoDBAttributeValue> other$newImage = other.getNewImage();
        if (this$newImage == null ? other$newImage != null : !((Object)this$newImage).equals(other$newImage)) {
            return false;
        }
        Map<String, DynamoDBAttributeValue> this$oldImage = this.getOldImage();
        Map<String, DynamoDBAttributeValue> other$oldImage = other.getOldImage();
        if (this$oldImage == null ? other$oldImage != null : !((Object)this$oldImage).equals(other$oldImage)) {
            return false;
        }
        String this$sequenceNumber = this.getSequenceNumber();
        String other$sequenceNumber = other.getSequenceNumber();
        if (this$sequenceNumber == null ? other$sequenceNumber != null : !this$sequenceNumber.equals(other$sequenceNumber)) {
            return false;
        }
        StreamViewType this$streamViewType = this.getStreamViewType();
        StreamViewType other$streamViewType = other.getStreamViewType();
        return !(this$streamViewType == null ? other$streamViewType != null : !((Object)((Object)this$streamViewType)).equals((Object)other$streamViewType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DynamoDBStreamRecord;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $approximateCreationDateTime = this.getApproximateCreationDateTime();
        result = result * 59 + (int)($approximateCreationDateTime >>> 32 ^ $approximateCreationDateTime);
        Long $sizeBytes = this.getSizeBytes();
        result = result * 59 + ($sizeBytes == null ? 43 : ((Object)$sizeBytes).hashCode());
        Map<String, DynamoDBAttributeValue> $keys = this.getKeys();
        result = result * 59 + ($keys == null ? 43 : ((Object)$keys).hashCode());
        Map<String, DynamoDBAttributeValue> $newImage = this.getNewImage();
        result = result * 59 + ($newImage == null ? 43 : ((Object)$newImage).hashCode());
        Map<String, DynamoDBAttributeValue> $oldImage = this.getOldImage();
        result = result * 59 + ($oldImage == null ? 43 : ((Object)$oldImage).hashCode());
        String $sequenceNumber = this.getSequenceNumber();
        result = result * 59 + ($sequenceNumber == null ? 43 : $sequenceNumber.hashCode());
        StreamViewType $streamViewType = this.getStreamViewType();
        result = result * 59 + ($streamViewType == null ? 43 : ((Object)((Object)$streamViewType)).hashCode());
        return result;
    }

    public String toString() {
        return "DynamoDBStreamRecord(approximateCreationDateTime=" + this.getApproximateCreationDateTime() + ", keys=" + this.getKeys() + ", newImage=" + this.getNewImage() + ", oldImage=" + this.getOldImage() + ", sequenceNumber=" + this.getSequenceNumber() + ", sizeBytes=" + this.getSizeBytes() + ", streamViewType=" + this.getStreamViewType() + ")";
    }

    public static enum StreamViewType {
        NEW_IMAGE,
        OLD_IMAGE,
        NEW_AND_OLD_IMAGES,
        KEYS_ONLY;

    }
}

