/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.aws.lambda.events.s3;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class S3EventNotification {
    private List<S3EventNotificationRecord> records;

    @NotNull
    public List<S3EventNotificationRecord> getRecords() {
        return this.records == null ? Collections.emptyList() : this.records;
    }

    public S3EventNotification setRecords(List<S3EventNotificationRecord> records) {
        this.records = records;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof S3EventNotification)) {
            return false;
        }
        S3EventNotification other = (S3EventNotification)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<S3EventNotificationRecord> this$records = this.getRecords();
        List<S3EventNotificationRecord> other$records = other.getRecords();
        return !(this$records == null ? other$records != null : !((Object)this$records).equals(other$records));
    }

    protected boolean canEqual(Object other) {
        return other instanceof S3EventNotification;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<S3EventNotificationRecord> $records = this.getRecords();
        result = result * 59 + ($records == null ? 43 : ((Object)$records).hashCode());
        return result;
    }

    public String toString() {
        return "S3EventNotification(records=" + this.getRecords() + ")";
    }

    public static class S3EventNotificationRecord {
        private String awsRegion;
        private String eventName;
        private String eventSource;
        private String eventTime;
        private String eventVersion;
        private RequestParametersEntity requestParameters;
        private ResponseElementsEntity responseElements;
        private S3Entity s3;
        private UserIdentityEntity userIdentity;

        public LocalDateTime getEventDateTime() {
            return LocalDateTime.parse(this.eventTime);
        }

        public String getAwsRegion() {
            return this.awsRegion;
        }

        public String getEventName() {
            return this.eventName;
        }

        public String getEventSource() {
            return this.eventSource;
        }

        public String getEventTime() {
            return this.eventTime;
        }

        public String getEventVersion() {
            return this.eventVersion;
        }

        public RequestParametersEntity getRequestParameters() {
            return this.requestParameters;
        }

        public ResponseElementsEntity getResponseElements() {
            return this.responseElements;
        }

        public S3Entity getS3() {
            return this.s3;
        }

        public UserIdentityEntity getUserIdentity() {
            return this.userIdentity;
        }

        public S3EventNotificationRecord setAwsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        public S3EventNotificationRecord setEventName(String eventName) {
            this.eventName = eventName;
            return this;
        }

        public S3EventNotificationRecord setEventSource(String eventSource) {
            this.eventSource = eventSource;
            return this;
        }

        public S3EventNotificationRecord setEventTime(String eventTime) {
            this.eventTime = eventTime;
            return this;
        }

        public S3EventNotificationRecord setEventVersion(String eventVersion) {
            this.eventVersion = eventVersion;
            return this;
        }

        public S3EventNotificationRecord setRequestParameters(RequestParametersEntity requestParameters) {
            this.requestParameters = requestParameters;
            return this;
        }

        public S3EventNotificationRecord setResponseElements(ResponseElementsEntity responseElements) {
            this.responseElements = responseElements;
            return this;
        }

        public S3EventNotificationRecord setS3(S3Entity s3) {
            this.s3 = s3;
            return this;
        }

        public S3EventNotificationRecord setUserIdentity(UserIdentityEntity userIdentity) {
            this.userIdentity = userIdentity;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof S3EventNotificationRecord)) {
                return false;
            }
            S3EventNotificationRecord other = (S3EventNotificationRecord)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$awsRegion = this.getAwsRegion();
            String other$awsRegion = other.getAwsRegion();
            if (this$awsRegion == null ? other$awsRegion != null : !this$awsRegion.equals(other$awsRegion)) {
                return false;
            }
            String this$eventName = this.getEventName();
            String other$eventName = other.getEventName();
            if (this$eventName == null ? other$eventName != null : !this$eventName.equals(other$eventName)) {
                return false;
            }
            String this$eventSource = this.getEventSource();
            String other$eventSource = other.getEventSource();
            if (this$eventSource == null ? other$eventSource != null : !this$eventSource.equals(other$eventSource)) {
                return false;
            }
            String this$eventTime = this.getEventTime();
            String other$eventTime = other.getEventTime();
            if (this$eventTime == null ? other$eventTime != null : !this$eventTime.equals(other$eventTime)) {
                return false;
            }
            String this$eventVersion = this.getEventVersion();
            String other$eventVersion = other.getEventVersion();
            if (this$eventVersion == null ? other$eventVersion != null : !this$eventVersion.equals(other$eventVersion)) {
                return false;
            }
            RequestParametersEntity this$requestParameters = this.getRequestParameters();
            RequestParametersEntity other$requestParameters = other.getRequestParameters();
            if (this$requestParameters == null ? other$requestParameters != null : !((Object)this$requestParameters).equals(other$requestParameters)) {
                return false;
            }
            ResponseElementsEntity this$responseElements = this.getResponseElements();
            ResponseElementsEntity other$responseElements = other.getResponseElements();
            if (this$responseElements == null ? other$responseElements != null : !((Object)this$responseElements).equals(other$responseElements)) {
                return false;
            }
            S3Entity this$s3 = this.getS3();
            S3Entity other$s3 = other.getS3();
            if (this$s3 == null ? other$s3 != null : !((Object)this$s3).equals(other$s3)) {
                return false;
            }
            UserIdentityEntity this$userIdentity = this.getUserIdentity();
            UserIdentityEntity other$userIdentity = other.getUserIdentity();
            return !(this$userIdentity == null ? other$userIdentity != null : !((Object)this$userIdentity).equals(other$userIdentity));
        }

        protected boolean canEqual(Object other) {
            return other instanceof S3EventNotificationRecord;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $awsRegion = this.getAwsRegion();
            result = result * 59 + ($awsRegion == null ? 43 : $awsRegion.hashCode());
            String $eventName = this.getEventName();
            result = result * 59 + ($eventName == null ? 43 : $eventName.hashCode());
            String $eventSource = this.getEventSource();
            result = result * 59 + ($eventSource == null ? 43 : $eventSource.hashCode());
            String $eventTime = this.getEventTime();
            result = result * 59 + ($eventTime == null ? 43 : $eventTime.hashCode());
            String $eventVersion = this.getEventVersion();
            result = result * 59 + ($eventVersion == null ? 43 : $eventVersion.hashCode());
            RequestParametersEntity $requestParameters = this.getRequestParameters();
            result = result * 59 + ($requestParameters == null ? 43 : ((Object)$requestParameters).hashCode());
            ResponseElementsEntity $responseElements = this.getResponseElements();
            result = result * 59 + ($responseElements == null ? 43 : ((Object)$responseElements).hashCode());
            S3Entity $s3 = this.getS3();
            result = result * 59 + ($s3 == null ? 43 : ((Object)$s3).hashCode());
            UserIdentityEntity $userIdentity = this.getUserIdentity();
            result = result * 59 + ($userIdentity == null ? 43 : ((Object)$userIdentity).hashCode());
            return result;
        }

        public String toString() {
            return "S3EventNotification.S3EventNotificationRecord(awsRegion=" + this.getAwsRegion() + ", eventName=" + this.getEventName() + ", eventSource=" + this.getEventSource() + ", eventTime=" + this.getEventTime() + ", eventVersion=" + this.getEventVersion() + ", requestParameters=" + this.getRequestParameters() + ", responseElements=" + this.getResponseElements() + ", s3=" + this.getS3() + ", userIdentity=" + this.getUserIdentity() + ")";
        }
    }

    public static class ResponseElementsEntity {
        private final String xAmzId2;
        private final String xAmzRequestId;

        public ResponseElementsEntity(String xAmzId2, String xAmzRequestId) {
            this.xAmzId2 = xAmzId2;
            this.xAmzRequestId = xAmzRequestId;
        }

        public String getXAmzId2() {
            return this.xAmzId2;
        }

        public String getXAmzRequestId() {
            return this.xAmzRequestId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResponseElementsEntity)) {
                return false;
            }
            ResponseElementsEntity other = (ResponseElementsEntity)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$xAmzId2 = this.getXAmzId2();
            String other$xAmzId2 = other.getXAmzId2();
            if (this$xAmzId2 == null ? other$xAmzId2 != null : !this$xAmzId2.equals(other$xAmzId2)) {
                return false;
            }
            String this$xAmzRequestId = this.getXAmzRequestId();
            String other$xAmzRequestId = other.getXAmzRequestId();
            return !(this$xAmzRequestId == null ? other$xAmzRequestId != null : !this$xAmzRequestId.equals(other$xAmzRequestId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ResponseElementsEntity;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $xAmzId2 = this.getXAmzId2();
            result = result * 59 + ($xAmzId2 == null ? 43 : $xAmzId2.hashCode());
            String $xAmzRequestId = this.getXAmzRequestId();
            result = result * 59 + ($xAmzRequestId == null ? 43 : $xAmzRequestId.hashCode());
            return result;
        }

        public String toString() {
            return "S3EventNotification.ResponseElementsEntity(xAmzId2=" + this.getXAmzId2() + ", xAmzRequestId=" + this.getXAmzRequestId() + ")";
        }
    }

    public static class RequestParametersEntity {
        private String sourceIPAddress;

        public String getSourceIPAddress() {
            return this.sourceIPAddress;
        }

        public RequestParametersEntity setSourceIPAddress(String sourceIPAddress) {
            this.sourceIPAddress = sourceIPAddress;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RequestParametersEntity)) {
                return false;
            }
            RequestParametersEntity other = (RequestParametersEntity)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$sourceIPAddress = this.getSourceIPAddress();
            String other$sourceIPAddress = other.getSourceIPAddress();
            return !(this$sourceIPAddress == null ? other$sourceIPAddress != null : !this$sourceIPAddress.equals(other$sourceIPAddress));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RequestParametersEntity;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $sourceIPAddress = this.getSourceIPAddress();
            result = result * 59 + ($sourceIPAddress == null ? 43 : $sourceIPAddress.hashCode());
            return result;
        }

        public String toString() {
            return "S3EventNotification.RequestParametersEntity(sourceIPAddress=" + this.getSourceIPAddress() + ")";
        }
    }

    public static class S3Entity {
        private String configurationId;
        private S3BucketEntity bucket;
        private S3ObjectEntity object;
        private String s3SchemaVersion;

        public String getConfigurationId() {
            return this.configurationId;
        }

        public S3BucketEntity getBucket() {
            return this.bucket;
        }

        public S3ObjectEntity getObject() {
            return this.object;
        }

        public String getS3SchemaVersion() {
            return this.s3SchemaVersion;
        }

        public S3Entity setConfigurationId(String configurationId) {
            this.configurationId = configurationId;
            return this;
        }

        public S3Entity setBucket(S3BucketEntity bucket) {
            this.bucket = bucket;
            return this;
        }

        public S3Entity setObject(S3ObjectEntity object) {
            this.object = object;
            return this;
        }

        public S3Entity setS3SchemaVersion(String s3SchemaVersion) {
            this.s3SchemaVersion = s3SchemaVersion;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof S3Entity)) {
                return false;
            }
            S3Entity other = (S3Entity)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$configurationId = this.getConfigurationId();
            String other$configurationId = other.getConfigurationId();
            if (this$configurationId == null ? other$configurationId != null : !this$configurationId.equals(other$configurationId)) {
                return false;
            }
            S3BucketEntity this$bucket = this.getBucket();
            S3BucketEntity other$bucket = other.getBucket();
            if (this$bucket == null ? other$bucket != null : !((Object)this$bucket).equals(other$bucket)) {
                return false;
            }
            S3ObjectEntity this$object = this.getObject();
            S3ObjectEntity other$object = other.getObject();
            if (this$object == null ? other$object != null : !((Object)this$object).equals(other$object)) {
                return false;
            }
            String this$s3SchemaVersion = this.getS3SchemaVersion();
            String other$s3SchemaVersion = other.getS3SchemaVersion();
            return !(this$s3SchemaVersion == null ? other$s3SchemaVersion != null : !this$s3SchemaVersion.equals(other$s3SchemaVersion));
        }

        protected boolean canEqual(Object other) {
            return other instanceof S3Entity;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $configurationId = this.getConfigurationId();
            result = result * 59 + ($configurationId == null ? 43 : $configurationId.hashCode());
            S3BucketEntity $bucket = this.getBucket();
            result = result * 59 + ($bucket == null ? 43 : ((Object)$bucket).hashCode());
            S3ObjectEntity $object = this.getObject();
            result = result * 59 + ($object == null ? 43 : ((Object)$object).hashCode());
            String $s3SchemaVersion = this.getS3SchemaVersion();
            result = result * 59 + ($s3SchemaVersion == null ? 43 : $s3SchemaVersion.hashCode());
            return result;
        }

        public String toString() {
            return "S3EventNotification.S3Entity(configurationId=" + this.getConfigurationId() + ", bucket=" + this.getBucket() + ", object=" + this.getObject() + ", s3SchemaVersion=" + this.getS3SchemaVersion() + ")";
        }
    }

    public static class S3ObjectEntity {
        private static final String DEFAULT_ENCODING = "UTF-8";
        private String key;
        private Long size;
        private String eTag;
        private String versionId;
        private String sequencer;

        public String getUrlDecodedKey() {
            return this.key == null ? null : URLDecoder.decode(this.key, StandardCharsets.UTF_8);
        }

        public String getKey() {
            return this.key;
        }

        public Long getSize() {
            return this.size;
        }

        public String getETag() {
            return this.eTag;
        }

        public String getVersionId() {
            return this.versionId;
        }

        public String getSequencer() {
            return this.sequencer;
        }

        public S3ObjectEntity setKey(String key) {
            this.key = key;
            return this;
        }

        public S3ObjectEntity setSize(Long size) {
            this.size = size;
            return this;
        }

        public S3ObjectEntity setETag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public S3ObjectEntity setVersionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public S3ObjectEntity setSequencer(String sequencer) {
            this.sequencer = sequencer;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof S3ObjectEntity)) {
                return false;
            }
            S3ObjectEntity other = (S3ObjectEntity)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$size = this.getSize();
            Long other$size = other.getSize();
            if (this$size == null ? other$size != null : !((Object)this$size).equals(other$size)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            String this$eTag = this.getETag();
            String other$eTag = other.getETag();
            if (this$eTag == null ? other$eTag != null : !this$eTag.equals(other$eTag)) {
                return false;
            }
            String this$versionId = this.getVersionId();
            String other$versionId = other.getVersionId();
            if (this$versionId == null ? other$versionId != null : !this$versionId.equals(other$versionId)) {
                return false;
            }
            String this$sequencer = this.getSequencer();
            String other$sequencer = other.getSequencer();
            return !(this$sequencer == null ? other$sequencer != null : !this$sequencer.equals(other$sequencer));
        }

        protected boolean canEqual(Object other) {
            return other instanceof S3ObjectEntity;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $size = this.getSize();
            result = result * 59 + ($size == null ? 43 : ((Object)$size).hashCode());
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            String $eTag = this.getETag();
            result = result * 59 + ($eTag == null ? 43 : $eTag.hashCode());
            String $versionId = this.getVersionId();
            result = result * 59 + ($versionId == null ? 43 : $versionId.hashCode());
            String $sequencer = this.getSequencer();
            result = result * 59 + ($sequencer == null ? 43 : $sequencer.hashCode());
            return result;
        }

        public String toString() {
            return "S3EventNotification.S3ObjectEntity(key=" + this.getKey() + ", size=" + this.getSize() + ", eTag=" + this.getETag() + ", versionId=" + this.getVersionId() + ", sequencer=" + this.getSequencer() + ")";
        }
    }

    public static class S3BucketEntity {
        private String name;
        private UserIdentityEntity ownerIdentity;
        private String arn;

        public String getName() {
            return this.name;
        }

        public UserIdentityEntity getOwnerIdentity() {
            return this.ownerIdentity;
        }

        public String getArn() {
            return this.arn;
        }

        public S3BucketEntity setName(String name) {
            this.name = name;
            return this;
        }

        public S3BucketEntity setOwnerIdentity(UserIdentityEntity ownerIdentity) {
            this.ownerIdentity = ownerIdentity;
            return this;
        }

        public S3BucketEntity setArn(String arn) {
            this.arn = arn;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof S3BucketEntity)) {
                return false;
            }
            S3BucketEntity other = (S3BucketEntity)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            UserIdentityEntity this$ownerIdentity = this.getOwnerIdentity();
            UserIdentityEntity other$ownerIdentity = other.getOwnerIdentity();
            if (this$ownerIdentity == null ? other$ownerIdentity != null : !((Object)this$ownerIdentity).equals(other$ownerIdentity)) {
                return false;
            }
            String this$arn = this.getArn();
            String other$arn = other.getArn();
            return !(this$arn == null ? other$arn != null : !this$arn.equals(other$arn));
        }

        protected boolean canEqual(Object other) {
            return other instanceof S3BucketEntity;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            UserIdentityEntity $ownerIdentity = this.getOwnerIdentity();
            result = result * 59 + ($ownerIdentity == null ? 43 : ((Object)$ownerIdentity).hashCode());
            String $arn = this.getArn();
            result = result * 59 + ($arn == null ? 43 : $arn.hashCode());
            return result;
        }

        public String toString() {
            return "S3EventNotification.S3BucketEntity(name=" + this.getName() + ", ownerIdentity=" + this.getOwnerIdentity() + ", arn=" + this.getArn() + ")";
        }
    }

    public static class UserIdentityEntity {
        private String principalId;

        public String getPrincipalId() {
            return this.principalId;
        }

        public UserIdentityEntity setPrincipalId(String principalId) {
            this.principalId = principalId;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UserIdentityEntity)) {
                return false;
            }
            UserIdentityEntity other = (UserIdentityEntity)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$principalId = this.getPrincipalId();
            String other$principalId = other.getPrincipalId();
            return !(this$principalId == null ? other$principalId != null : !this$principalId.equals(other$principalId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof UserIdentityEntity;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $principalId = this.getPrincipalId();
            result = result * 59 + ($principalId == null ? 43 : $principalId.hashCode());
            return result;
        }

        public String toString() {
            return "S3EventNotification.UserIdentityEntity(principalId=" + this.getPrincipalId() + ")";
        }
    }
}

