/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.gson.configuration;

import com.google.gson.GsonBuilder;
import io.goodforgod.gson.configuration.GsonConfiguration;
import io.goodforgod.gson.configuration.deserializer.DayOfWeekDeserializer;
import io.goodforgod.gson.configuration.deserializer.InstantDeserializer;
import io.goodforgod.gson.configuration.deserializer.LocalDateDeserializer;
import io.goodforgod.gson.configuration.deserializer.LocalDateTimeDeserializer;
import io.goodforgod.gson.configuration.deserializer.LocalTimeDeserializer;
import io.goodforgod.gson.configuration.deserializer.MonthDayDeserializer;
import io.goodforgod.gson.configuration.deserializer.MonthDeserializer;
import io.goodforgod.gson.configuration.deserializer.OffsetDateTimeDeserializer;
import io.goodforgod.gson.configuration.deserializer.OffsetTimeDeserializer;
import io.goodforgod.gson.configuration.deserializer.YearDeserializer;
import io.goodforgod.gson.configuration.deserializer.YearMonthDeserializer;
import io.goodforgod.gson.configuration.deserializer.ZoneIdDeserializer;
import io.goodforgod.gson.configuration.deserializer.ZoneOffsetDeserializer;
import io.goodforgod.gson.configuration.deserializer.ZonedDateTimeDeserializer;
import io.goodforgod.gson.configuration.serializer.DayOfWeekSerializer;
import io.goodforgod.gson.configuration.serializer.InstantSerializer;
import io.goodforgod.gson.configuration.serializer.LocalDateSerializer;
import io.goodforgod.gson.configuration.serializer.LocalDateTimeSerializer;
import io.goodforgod.gson.configuration.serializer.LocalTimeSerializer;
import io.goodforgod.gson.configuration.serializer.MonthDaySerializer;
import io.goodforgod.gson.configuration.serializer.MonthSerializer;
import io.goodforgod.gson.configuration.serializer.OffsetDateTimeSerializer;
import io.goodforgod.gson.configuration.serializer.OffsetTimeSerializer;
import io.goodforgod.gson.configuration.serializer.YearMonthSerializer;
import io.goodforgod.gson.configuration.serializer.YearSerializer;
import io.goodforgod.gson.configuration.serializer.ZoneIdSerializer;
import io.goodforgod.gson.configuration.serializer.ZoneOffsetSerializer;
import io.goodforgod.gson.configuration.serializer.ZonedDateTimeSerializer;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;

final class GsonAdapterBuilder {
    private GsonAdapterBuilder() {
    }

    private static GsonBuilder getCommonBuilder() {
        return new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX").registerTypeAdapter(DayOfWeek.class, (Object)DayOfWeekDeserializer.INSTANCE).registerTypeAdapter(DayOfWeek.class, (Object)DayOfWeekSerializer.INSTANCE).registerTypeAdapter(Month.class, (Object)MonthDeserializer.INSTANCE).registerTypeAdapter(Month.class, (Object)MonthSerializer.INSTANCE).registerTypeHierarchyAdapter(ZoneId.class, (Object)ZoneIdDeserializer.INSTANCE).registerTypeHierarchyAdapter(ZoneId.class, (Object)ZoneIdSerializer.INSTANCE).registerTypeAdapter(ZoneOffset.class, (Object)ZoneOffsetDeserializer.INSTANCE).registerTypeAdapter(ZoneOffset.class, (Object)ZoneOffsetSerializer.INSTANCE);
    }

    static GsonBuilder builder(GsonConfiguration configuration) {
        return GsonAdapterBuilder.getCommonBuilder().setDateFormat(configuration.getDateFormat()).registerTypeAdapter(Year.class, (Object)(configuration.getYearFormat() == null ? YearDeserializer.INSTANCE : new YearDeserializer(configuration.getYearFormat()))).registerTypeAdapter(Year.class, (Object)(configuration.getYearFormat() == null ? YearSerializer.INSTANCE : new YearSerializer(configuration.getYearFormat()))).registerTypeAdapter(YearMonth.class, (Object)(configuration.getYearMonthFormat() == null ? YearMonthDeserializer.INSTANCE : new YearMonthDeserializer(configuration.getYearMonthFormat()))).registerTypeAdapter(YearMonth.class, (Object)(configuration.getYearMonthFormat() == null ? YearMonthSerializer.INSTANCE : new YearMonthSerializer(configuration.getYearMonthFormat()))).registerTypeAdapter(MonthDay.class, (Object)(configuration.getMonthDayFormat() == null ? MonthDayDeserializer.INSTANCE : new MonthDayDeserializer(configuration.getMonthDayFormat()))).registerTypeAdapter(MonthDay.class, (Object)(configuration.getMonthDayFormat() == null ? MonthDaySerializer.INSTANCE : new MonthDaySerializer(configuration.getMonthDayFormat()))).registerTypeAdapter(Instant.class, (Object)(configuration.getInstantFormat() == null ? InstantDeserializer.INSTANCE : new InstantDeserializer(configuration.getInstantFormat()))).registerTypeAdapter(Instant.class, (Object)(configuration.getInstantFormat() == null ? InstantSerializer.INSTANCE : new InstantSerializer(configuration.getInstantFormat()))).registerTypeAdapter(LocalDate.class, (Object)(configuration.getLocalDateFormat() == null ? LocalDateDeserializer.INSTANCE : new LocalDateDeserializer(configuration.getLocalDateFormat()))).registerTypeAdapter(LocalDate.class, (Object)(configuration.getLocalDateFormat() == null ? LocalDateSerializer.INSTANCE : new LocalDateSerializer(configuration.getLocalDateFormat()))).registerTypeAdapter(LocalTime.class, (Object)(configuration.getLocalTimeFormat() == null ? LocalTimeDeserializer.INSTANCE : new LocalTimeDeserializer(configuration.getLocalTimeFormat()))).registerTypeAdapter(LocalTime.class, (Object)(configuration.getLocalTimeFormat() == null ? LocalTimeSerializer.INSTANCE : new LocalTimeSerializer(configuration.getLocalTimeFormat()))).registerTypeAdapter(LocalDateTime.class, (Object)(configuration.getLocalDateTimeFormat() == null ? LocalDateTimeDeserializer.INSTANCE : new LocalDateTimeDeserializer(configuration.getLocalDateTimeFormat()))).registerTypeAdapter(LocalDateTime.class, (Object)(configuration.getLocalDateTimeFormat() == null ? LocalDateTimeSerializer.INSTANCE : new LocalDateTimeSerializer(configuration.getLocalDateTimeFormat()))).registerTypeAdapter(OffsetTime.class, (Object)(configuration.getOffsetTimeFormat() == null ? OffsetTimeDeserializer.INSTANCE : new OffsetTimeDeserializer(configuration.getOffsetTimeFormat()))).registerTypeAdapter(OffsetTime.class, (Object)(configuration.getOffsetTimeFormat() == null ? OffsetTimeSerializer.INSTANCE : new OffsetTimeSerializer(configuration.getOffsetTimeFormat()))).registerTypeAdapter(OffsetDateTime.class, (Object)(configuration.getOffsetDateTimeFormat() == null ? OffsetDateTimeDeserializer.INSTANCE : new OffsetDateTimeDeserializer(configuration.getOffsetDateTimeFormat()))).registerTypeAdapter(OffsetDateTime.class, (Object)(configuration.getOffsetDateTimeFormat() == null ? OffsetDateTimeSerializer.INSTANCE : new OffsetDateTimeSerializer(configuration.getOffsetDateTimeFormat()))).registerTypeAdapter(ZonedDateTime.class, (Object)(configuration.getZonedDateTimeFormat() == null ? ZonedDateTimeDeserializer.INSTANCE : new ZonedDateTimeDeserializer(configuration.getZonedDateTimeFormat()))).registerTypeAdapter(ZonedDateTime.class, (Object)(configuration.getZonedDateTimeFormat() == null ? ZonedDateTimeSerializer.INSTANCE : new ZonedDateTimeSerializer(configuration.getZonedDateTimeFormat())));
    }
}

