/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.gson.configuration;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.GsonBuilder;
import com.google.gson.LongSerializationPolicy;
import io.goodforgod.gson.configuration.GsonAdapterBuilder;
import java.text.SimpleDateFormat;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.format.ResolverStyle;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;

public class GsonConfiguration {
    private static final Set<FieldModifiers> DEFAULT_EXCLUDED_MODIFIERS;
    private DateTimeFormatter instantFormat;
    private DateTimeFormatter localDateFormat;
    private DateTimeFormatter localTimeFormat;
    private DateTimeFormatter localDateTimeFormat;
    private DateTimeFormatter offsetTimeFormat;
    private DateTimeFormatter offsetDateTimeFormat;
    private DateTimeFormatter zonedDateTimeFormat;
    private DateTimeFormatter yearFormat;
    private DateTimeFormatter yearMonthFormat;
    private DateTimeFormatter monthDayFormat;
    private String dateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";
    private boolean forceResolverStrict = false;
    private boolean forceIsoChronology = false;
    private FieldNamingPolicy fieldNamingPolicy = FieldNamingPolicy.IDENTITY;
    private LongSerializationPolicy longSerializationPolicy = LongSerializationPolicy.DEFAULT;
    private boolean serializeNulls = false;
    private boolean excludeFieldsWithoutExposeAnnotation = false;
    private Set<FieldModifiers> excludeFieldsWithModifiers = DEFAULT_EXCLUDED_MODIFIERS;
    private boolean complexMapKeySerialization = false;
    private boolean generateNonExecutableJson = false;
    private boolean escapeHtmlChars = true;
    private boolean prettyPrinting = false;
    private boolean lenient = false;
    private boolean serializeSpecialFloatingPointValues = false;

    public static GsonConfiguration ofProperties(Properties properties) {
        return GsonConfiguration.ofProperties(new GsonConfiguration(), properties);
    }

    private static GsonConfiguration ofProperties(GsonConfiguration configuration, Properties properties) {
        String formatInstant = properties.getProperty("gson.format.instant");
        String formatLocalDate = properties.getProperty("gson.format.localDate");
        String formatLocalTime = properties.getProperty("gson.format.localTime");
        String formatLocalDateTime = properties.getProperty("gson.format.localDateTime");
        String formatOffsetTime = properties.getProperty("gson.format.offsetTime");
        String formatOffsetDateTime = properties.getProperty("gson.format.offsetDateTime");
        String formatZonedDateTime = properties.getProperty("gson.format.zonedDateTime");
        String formatYear = properties.getProperty("gson.format.year");
        String formatYearMonth = properties.getProperty("gson.format.yearMonth");
        String formatMonthDay = properties.getProperty("gson.format.monthDay");
        String formatDate = properties.getProperty("gson.format.date");
        String forceIsoChronologyProp = properties.getProperty("gson.forceIsoChronology");
        String forceResolverStrictProp = properties.getProperty("gson.forceResolverStrict");
        String fieldNamingPolicy = properties.getProperty("gson.policy.fieldNaming");
        String longSerializationPolicy = properties.getProperty("gson.policy.longSerialization");
        String lenient = properties.getProperty("gson.lenient");
        String serializeNulls = properties.getProperty("gson.serializeNulls");
        String prettyPrinting = properties.getProperty("gson.prettyPrinting");
        String escapeHtmlChars = properties.getProperty("gson.escapeHtmlChars");
        String generateNonExecutableJson = properties.getProperty("gson.generateNonExecutableJson");
        String complexMapKeySerialization = properties.getProperty("gson.serializeComplexMapKey");
        String serializeSpecialFloatingPointValues = properties.getProperty("gson.serializeSpecialFloatingPointValues");
        String excludeFieldsWithoutExposeAnnotation = properties.getProperty("gson.excludeFieldsWithoutExposeAnnotation");
        String excludeFieldsWithModifiers = properties.getProperty("gson.excludeFieldsWithModifiers");
        if (formatInstant != null) {
            configuration.setInstantFormat(formatInstant);
        }
        if (formatLocalDate != null) {
            configuration.setLocalDateFormat(formatLocalDate);
        }
        if (formatLocalTime != null) {
            configuration.setLocalTimeFormat(formatLocalTime);
        }
        if (formatLocalDateTime != null) {
            configuration.setLocalDateTimeFormat(formatLocalDateTime);
        }
        if (formatOffsetTime != null) {
            configuration.setOffsetTimeFormat(formatOffsetTime);
        }
        if (formatOffsetDateTime != null) {
            configuration.setOffsetDateTimeFormat(formatOffsetDateTime);
        }
        if (formatZonedDateTime != null) {
            configuration.setZonedDateTimeFormat(formatZonedDateTime);
        }
        if (formatYear != null) {
            configuration.setYearFormat(formatYear);
        }
        if (formatYearMonth != null) {
            configuration.setYearMonthFormat(formatYearMonth);
        }
        if (formatMonthDay != null) {
            configuration.setMonthDayFormat(formatMonthDay);
        }
        if (formatDate != null) {
            configuration.setDateFormat(formatDate);
        }
        if (forceIsoChronologyProp != null) {
            configuration.setForceIsoChronology(Boolean.parseBoolean(forceIsoChronologyProp));
        }
        if (forceResolverStrictProp != null) {
            configuration.setForceResolverStrict(Boolean.parseBoolean(forceResolverStrictProp));
        }
        if (fieldNamingPolicy != null) {
            configuration.setFieldNamingPolicy(FieldNamingPolicy.valueOf((String)fieldNamingPolicy));
        }
        if (longSerializationPolicy != null) {
            configuration.setLongSerializationPolicy(LongSerializationPolicy.valueOf((String)longSerializationPolicy));
        }
        if (lenient != null) {
            configuration.setLenient(Boolean.parseBoolean(lenient));
        }
        if (serializeNulls != null) {
            configuration.setSerializeNulls(Boolean.parseBoolean(serializeNulls));
        }
        if (prettyPrinting != null) {
            configuration.setPrettyPrinting(Boolean.parseBoolean(prettyPrinting));
        }
        if (escapeHtmlChars != null) {
            configuration.setEscapeHtmlChars(Boolean.parseBoolean(escapeHtmlChars));
        }
        if (generateNonExecutableJson != null) {
            configuration.setGenerateNonExecutableJson(Boolean.parseBoolean(generateNonExecutableJson));
        }
        if (complexMapKeySerialization != null) {
            configuration.setComplexMapKeySerialization(Boolean.parseBoolean(complexMapKeySerialization));
        }
        if (serializeSpecialFloatingPointValues != null) {
            configuration.setSerializeSpecialFloatingPointValues(Boolean.parseBoolean(serializeSpecialFloatingPointValues));
        }
        if (excludeFieldsWithoutExposeAnnotation != null) {
            configuration.setExcludeFieldsWithoutExposeAnnotation(Boolean.parseBoolean(excludeFieldsWithoutExposeAnnotation));
        }
        if (excludeFieldsWithModifiers != null) {
            Set<FieldModifiers> modifiers = Arrays.stream(excludeFieldsWithModifiers.split(",")).map(FieldModifiers::valueOf).collect(Collectors.toSet());
            configuration.setExcludeFieldsWithModifiers(modifiers);
        }
        return configuration;
    }

    public GsonBuilder builder() {
        GsonBuilder builder = GsonAdapterBuilder.builder(this).setDateFormat(this.getDateFormat()).setLongSerializationPolicy(this.getLongSerializationPolicy()).setFieldNamingPolicy(this.getFieldNamingPolicy());
        int[] modifiers = this.getExcludeFieldsWithModifiers().stream().mapToInt(m -> ((FieldModifiers)m).modifier).toArray();
        builder.excludeFieldsWithModifiers(modifiers);
        if (this.isExcludeFieldsWithoutExposeAnnotation()) {
            builder.excludeFieldsWithoutExposeAnnotation();
        }
        if (this.isComplexMapKeySerialization()) {
            builder.enableComplexMapKeySerialization();
        }
        if (this.isGenerateNonExecutableJson()) {
            builder.generateNonExecutableJson();
        }
        if (this.isLenient()) {
            builder.setLenient();
        }
        if (this.isPrettyPrinting()) {
            builder.setPrettyPrinting();
        }
        if (this.isSerializeSpecialFloatingPointValues()) {
            builder.serializeSpecialFloatingPointValues();
        }
        if (this.isSerializeNulls()) {
            builder.serializeNulls();
        }
        if (!this.isEscapeHtmlChars()) {
            builder.disableHtmlEscaping();
        }
        return builder;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public GsonConfiguration setDateFormat(String dateFormat) {
        this.dateFormat = new SimpleDateFormat(dateFormat).toPattern();
        return this;
    }

    public boolean isForceResolverStrict() {
        return this.forceResolverStrict;
    }

    public GsonConfiguration setForceResolverStrict(boolean forceResolverStrict) {
        this.forceResolverStrict = forceResolverStrict;
        return this;
    }

    public boolean isForceIsoChronology() {
        return this.forceIsoChronology;
    }

    public GsonConfiguration setForceIsoChronology(boolean forceIsoChronology) {
        this.forceIsoChronology = forceIsoChronology;
        return this;
    }

    public FieldNamingPolicy getFieldNamingPolicy() {
        return this.fieldNamingPolicy;
    }

    public GsonConfiguration setFieldNamingPolicy(FieldNamingPolicy fieldNamingPolicy) {
        if (fieldNamingPolicy == null) {
            throw new IllegalArgumentException("Policy can not be nullable!");
        }
        this.fieldNamingPolicy = fieldNamingPolicy;
        return this;
    }

    public LongSerializationPolicy getLongSerializationPolicy() {
        return this.longSerializationPolicy;
    }

    public GsonConfiguration setLongSerializationPolicy(LongSerializationPolicy longSerializationPolicy) {
        if (longSerializationPolicy == null) {
            throw new IllegalArgumentException("Policy can not be nullable!");
        }
        this.longSerializationPolicy = longSerializationPolicy;
        return this;
    }

    public boolean isSerializeNulls() {
        return this.serializeNulls;
    }

    public GsonConfiguration setSerializeNulls(boolean serializeNulls) {
        this.serializeNulls = serializeNulls;
        return this;
    }

    public boolean isComplexMapKeySerialization() {
        return this.complexMapKeySerialization;
    }

    public GsonConfiguration setComplexMapKeySerialization(boolean complexMapKeySerialization) {
        this.complexMapKeySerialization = complexMapKeySerialization;
        return this;
    }

    public boolean isGenerateNonExecutableJson() {
        return this.generateNonExecutableJson;
    }

    public GsonConfiguration setGenerateNonExecutableJson(boolean generateNonExecutableJson) {
        this.generateNonExecutableJson = generateNonExecutableJson;
        return this;
    }

    public boolean isEscapeHtmlChars() {
        return this.escapeHtmlChars;
    }

    public GsonConfiguration setEscapeHtmlChars(boolean escapeHtmlChars) {
        this.escapeHtmlChars = escapeHtmlChars;
        return this;
    }

    public boolean isPrettyPrinting() {
        return this.prettyPrinting;
    }

    public GsonConfiguration setPrettyPrinting(boolean prettyPrinting) {
        this.prettyPrinting = prettyPrinting;
        return this;
    }

    public boolean isLenient() {
        return this.lenient;
    }

    public GsonConfiguration setLenient(boolean lenient) {
        this.lenient = lenient;
        return this;
    }

    public boolean isSerializeSpecialFloatingPointValues() {
        return this.serializeSpecialFloatingPointValues;
    }

    public GsonConfiguration setSerializeSpecialFloatingPointValues(boolean serializeSpecialFloatingPointValues) {
        this.serializeSpecialFloatingPointValues = serializeSpecialFloatingPointValues;
        return this;
    }

    public boolean isExcludeFieldsWithoutExposeAnnotation() {
        return this.excludeFieldsWithoutExposeAnnotation;
    }

    public GsonConfiguration setExcludeFieldsWithoutExposeAnnotation(boolean excludeFieldsWithoutExposeAnnotation) {
        this.excludeFieldsWithoutExposeAnnotation = excludeFieldsWithoutExposeAnnotation;
        return this;
    }

    public Set<FieldModifiers> getExcludeFieldsWithModifiers() {
        return this.excludeFieldsWithModifiers;
    }

    public GsonConfiguration setExcludeFieldsWithModifiers(Set<FieldModifiers> excludeFieldsWithModifiers) {
        this.excludeFieldsWithModifiers = Collections.unmodifiableSet(excludeFieldsWithModifiers);
        return this;
    }

    public GsonConfiguration setExcludeFieldsWithModifiers(FieldModifiers ... excludeFieldsWithModifiers) {
        this.excludeFieldsWithModifiers = Collections.unmodifiableSet(Arrays.stream(excludeFieldsWithModifiers).collect(Collectors.toSet()));
        return this;
    }

    public DateTimeFormatter getInstantFormat() {
        return this.instantFormat;
    }

    public GsonConfiguration setInstantFormat(DateTimeFormatter instantFormat) {
        this.instantFormat = this.applyRestrictions(instantFormat);
        return this;
    }

    public GsonConfiguration setInstantFormat(String instantPattern) {
        return this.setInstantFormat(DateTimeFormatter.ofPattern(instantPattern));
    }

    public DateTimeFormatter getLocalDateFormat() {
        return this.localDateFormat;
    }

    public GsonConfiguration setLocalDateFormat(DateTimeFormatter localDateFormat) {
        this.localDateFormat = this.applyRestrictions(localDateFormat);
        return this;
    }

    public GsonConfiguration setLocalDateFormat(String localDatePattern) {
        return this.setLocalDateFormat(DateTimeFormatter.ofPattern(localDatePattern));
    }

    public DateTimeFormatter getLocalTimeFormat() {
        return this.localTimeFormat;
    }

    public GsonConfiguration setLocalTimeFormat(DateTimeFormatter localTimeFormat) {
        this.localTimeFormat = this.applyRestrictions(localTimeFormat);
        return this;
    }

    public GsonConfiguration setLocalTimeFormat(String localTimePattern) {
        return this.setLocalTimeFormat(DateTimeFormatter.ofPattern(localTimePattern));
    }

    public DateTimeFormatter getLocalDateTimeFormat() {
        return this.localDateTimeFormat;
    }

    public GsonConfiguration setLocalDateTimeFormat(DateTimeFormatter localDateTimeFormat) {
        this.localDateTimeFormat = this.applyRestrictions(localDateTimeFormat);
        return this;
    }

    public GsonConfiguration setLocalDateTimeFormat(String localDateTimePattern) {
        return this.setLocalDateTimeFormat(DateTimeFormatter.ofPattern(localDateTimePattern));
    }

    public DateTimeFormatter getOffsetTimeFormat() {
        return this.offsetTimeFormat;
    }

    public GsonConfiguration setOffsetTimeFormat(DateTimeFormatter offsetTimeFormat) {
        this.offsetTimeFormat = this.applyRestrictions(offsetTimeFormat);
        return this;
    }

    public GsonConfiguration setOffsetTimeFormat(String offsetTimePattern) {
        return this.setOffsetTimeFormat(DateTimeFormatter.ofPattern(offsetTimePattern));
    }

    public DateTimeFormatter getOffsetDateTimeFormat() {
        return this.offsetDateTimeFormat;
    }

    public GsonConfiguration setOffsetDateTimeFormat(DateTimeFormatter offsetDateTimeFormat) {
        this.offsetDateTimeFormat = this.applyRestrictions(offsetDateTimeFormat);
        return this;
    }

    public GsonConfiguration setOffsetDateTimeFormat(String offsetDateTimePattern) {
        return this.setOffsetDateTimeFormat(DateTimeFormatter.ofPattern(offsetDateTimePattern));
    }

    public DateTimeFormatter getZonedDateTimeFormat() {
        return this.zonedDateTimeFormat;
    }

    public GsonConfiguration setZonedDateTimeFormat(DateTimeFormatter zonedDateTimeFormat) {
        this.zonedDateTimeFormat = this.applyRestrictions(zonedDateTimeFormat);
        return this;
    }

    public GsonConfiguration setZonedDateTimeFormat(String zonedDateTimePattern) {
        return this.setZonedDateTimeFormat(DateTimeFormatter.ofPattern(zonedDateTimePattern));
    }

    public DateTimeFormatter getYearFormat() {
        return this.yearFormat;
    }

    public GsonConfiguration setYearFormat(DateTimeFormatter yearFormat) {
        this.yearFormat = this.applyRestrictions(yearFormat);
        return this;
    }

    public GsonConfiguration setYearFormat(String yearPattern) {
        return this.setYearFormat(DateTimeFormatter.ofPattern(yearPattern));
    }

    public DateTimeFormatter getYearMonthFormat() {
        return this.yearMonthFormat;
    }

    public GsonConfiguration setYearMonthFormat(DateTimeFormatter yearMonthFormat) {
        this.yearMonthFormat = this.applyRestrictions(yearMonthFormat);
        return this;
    }

    public GsonConfiguration setYearMonthFormat(String yearMonthPattern) {
        return this.setYearMonthFormat(DateTimeFormatter.ofPattern(yearMonthPattern));
    }

    public DateTimeFormatter getMonthDayFormat() {
        return this.monthDayFormat;
    }

    public GsonConfiguration setMonthDayFormat(DateTimeFormatter monthDayFormat) {
        this.monthDayFormat = this.applyRestrictions(monthDayFormat);
        return this;
    }

    public GsonConfiguration setMonthDayFormat(String monthDayPattern) {
        return this.setMonthDayFormat(DateTimeFormatter.ofPattern(monthDayPattern));
    }

    private DateTimeFormatter applyRestrictions(DateTimeFormatter formatter) {
        DateTimeFormatter processedFormatter = formatter;
        if (this.forceIsoChronology) {
            processedFormatter = processedFormatter.withChronology(IsoChronology.INSTANCE);
        }
        if (this.forceResolverStrict) {
            processedFormatter = processedFormatter.withResolverStyle(ResolverStyle.STRICT);
        }
        return processedFormatter;
    }

    static {
        HashSet<FieldModifiers> modifiers = new HashSet<FieldModifiers>(8);
        modifiers.add(FieldModifiers.TRANSIENT);
        modifiers.add(FieldModifiers.SYNCHRONIZED);
        modifiers.add(FieldModifiers.VOLATILE);
        modifiers.add(FieldModifiers.STATIC);
        DEFAULT_EXCLUDED_MODIFIERS = Collections.unmodifiableSet(modifiers);
    }

    public static enum FieldModifiers {
        PUBLIC(1),
        PROTECTED(4),
        PRIVATE(2),
        STATIC(8),
        FINAL(16),
        SYNCHRONIZED(32),
        VOLATILE(64),
        TRANSIENT(128);

        private final int modifier;

        private FieldModifiers(int modifier) {
            this.modifier = modifier;
        }

        public int modifier() {
            return this.modifier;
        }
    }
}

