/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.gson.configuration;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.goodforgod.gson.configuration.GsonConfiguration;
import java.io.InputStream;
import java.util.Properties;

public class GsonFactory {
    private static final String PROPERTY_FILE = "gson.properties";
    private Properties properties;
    private GsonConfiguration configuration;

    public Gson build() {
        return this.builder().create();
    }

    public GsonBuilder builder() {
        if (this.properties == null) {
            this.properties = this.getProperties();
        }
        if (this.configuration == null) {
            this.configuration = GsonConfiguration.ofProperties(this.properties);
        }
        return this.configuration.builder();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties getProperties() {
        try (InputStream resource = this.getClass().getClassLoader().getResourceAsStream(PROPERTY_FILE);){
            if (resource != null) {
                Properties resourceProperties = new Properties();
                resourceProperties.load(resource);
                Properties properties2 = resourceProperties;
                return properties2;
            }
            Properties properties = new Properties();
            return properties;
        }
        catch (Exception e) {
            return new Properties();
        }
    }
}

